/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.configuration;

import jakarta.servlet.Servlet;
import org.dspace.rdf.providing.DataProviderServlet;
import org.dspace.rdf.providing.LocalURIRedirectionServlet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RDFWebConfig {
    @Value(value="${rdf.path:rdf}")
    private String rdfPath;

    @Bean
    @ConditionalOnProperty(value={"rdf.enabled"})
    public ServletRegistrationBean rdfSerializationBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new DataProviderServlet(), new String[]{"/" + this.rdfPath + "/handle/*"});
        bean.setLoadOnStartup(1);
        return bean;
    }

    @Bean
    @ConditionalOnProperty(value={"rdf.enabled"})
    public ServletRegistrationBean rdfLocalURIRedirectionBean() {
        ServletRegistrationBean bean = new ServletRegistrationBean((Servlet)new LocalURIRedirectionServlet(), new String[]{"/" + this.rdfPath + "/resource/*"});
        bean.setLoadOnStartup(1);
        return bean;
    }
}

