/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.providing;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.rdf.negotiation.Negotiator;

public class LocalURIRedirectionServlet
extends HttpServlet {
    public static final String ACCEPT_HEADER_NAME = "Accept";
    private static final Logger log = LogManager.getLogger(LocalURIRedirectionServlet.class);
    protected final transient HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        log.debug("Pathinfo: " + pathInfo);
        if (StringUtils.isEmpty((CharSequence)pathInfo) || StringUtils.countMatches((CharSequence)pathInfo, (CharSequence)"/") < 2) {
            log.debug("Path does not contain the expected number of slashes.");
            response.sendError(404);
            return;
        }
        String[] path = request.getPathInfo().substring(1).split("/");
        Object handle = path[0] + "/" + path[1];
        int requestedMimeType = Negotiator.negotiate((String)request.getHeader(ACCEPT_HEADER_NAME));
        Context context = null;
        DSpaceObject dso = null;
        try {
            context = new Context(Context.Mode.READ_ONLY);
            dso = this.handleService.resolveToObject(context, (String)handle);
        }
        catch (SQLException ex) {
            log.error("SQLException: " + ex.getMessage(), (Throwable)ex);
            context.abort();
            response.sendError(503);
            return;
        }
        catch (IllegalStateException ex) {
            log.error("Cannot resolve handle " + (String)handle + ". IllegalStateException:" + ex.getMessage(), (Throwable)ex);
            context.abort();
            response.sendError(400);
            return;
        }
        if (dso == null) {
            log.info("Cannot resolve handle '" + (String)handle + "' to dso. => 404");
            context.abort();
            response.sendError(404);
            return;
        }
        handle = dso.getHandle();
        context.abort();
        Negotiator.sendRedirect((HttpServletResponse)response, (String)handle, (String)"", (int)requestedMimeType, (boolean)true);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Ensures that URIs used in RDF can be dereferenced.";
    }
}

