/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl.solr;

import org.apache.http.client.HttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.dspace.service.impl.HttpConnectionPoolService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.xoai.services.api.config.ConfigurationService;
import org.dspace.xoai.services.api.solr.SolrServerResolver;
import org.springframework.beans.factory.annotation.Autowired;

public class DSpaceSolrServerResolver
implements SolrServerResolver {
    private static final Logger log = LogManager.getLogger(DSpaceSolrServerResolver.class);
    private static SolrClient server = null;
    @Autowired
    private ConfigurationService configurationService;

    @Override
    public SolrClient getServer() throws SolrServerException {
        if (server == null) {
            String serverUrl = this.configurationService.getProperty("oai.solr.url");
            HttpConnectionPoolService httpConnectionPoolService = (HttpConnectionPoolService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("solrHttpConnectionPoolService", HttpConnectionPoolService.class);
            try {
                server = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(serverUrl).withHttpClient((HttpClient)httpConnectionPoolService.getClient())).build();
                log.debug("OAI Solr Server Initialized");
            }
            catch (Exception e) {
                log.error("Could not initialize OAI Solr Server at " + serverUrl, (Throwable)e);
            }
        }
        return server;
    }
}

