/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import com.lyncode.xoai.dataprovider.services.api.DateProvider;
import com.lyncode.xoai.dataprovider.services.impl.BaseDateProvider;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.util.Date;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.results.SolrFilterResult;

public class DateFromFilter
extends DSpaceFilter {
    private static final DateProvider dateProvider = new BaseDateProvider();
    private final Instant date;

    public DateFromFilter(Instant date) {
        this.date = date.with(ChronoField.MILLI_OF_SECOND, 0L);
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        return !item.getDatestamp().toInstant().isBefore(this.date);
    }

    @Override
    public SolrFilterResult buildSolrQuery() {
        String format = dateProvider.format(Date.from(this.date)).replace("Z", ".000Z");
        return new SolrFilterResult("item.lastmodified:[" + ClientUtils.escapeQueryChars((String)format) + " TO *]");
    }
}

