/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.services.impl;

import jakarta.persistence.NoResultException;
import java.sql.SQLException;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataValueService;
import org.dspace.core.Context;
import org.dspace.xoai.exceptions.InvalidMetadataFieldException;
import org.dspace.xoai.services.api.EarliestDateResolver;
import org.dspace.xoai.services.api.FieldResolver;
import org.springframework.beans.factory.annotation.Autowired;

public class DSpaceEarliestDateResolver
implements EarliestDateResolver {
    private static final Logger log = LogManager.getLogger(DSpaceEarliestDateResolver.class);
    @Autowired
    private FieldResolver fieldResolver;

    @Override
    public Instant getEarliestDate(Context context) throws InvalidMetadataFieldException, SQLException {
        MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
        MetadataValue minimum = null;
        try {
            minimum = metadataValueService.getMinimum(context, this.fieldResolver.getFieldID(context, "dc.date.available"));
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        if (null != minimum) {
            String str = minimum.getValue();
            try {
                Instant d = Instant.parse(str);
                if (d != null) {
                    return d;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return Instant.now();
    }
}

