/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.results.SolrFilterResult;

public class ItemsWithBitstreamFilter
extends DSpaceFilter {
    private static Logger log = LogManager.getLogger(ItemsWithBitstreamFilter.class);
    private static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    @Override
    public SolrFilterResult buildSolrQuery() {
        return new SolrFilterResult("item.hasbitstream:true");
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        try {
            String handle = DSpaceItem.parseHandle(item.getIdentifier());
            if (handle == null) {
                return false;
            }
            Item dspaceItem = (Item)handleService.resolveToObject(this.context, handle);
            for (Bundle b : dspaceItem.getBundles("ORIGINAL")) {
                if (b.getBitstreams().size() <= 0) continue;
                return true;
            }
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

