/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.data;

import com.lyncode.xoai.dataprovider.core.ItemMetadata;
import com.lyncode.xoai.dataprovider.core.ReferenceSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.dspace.xoai.data.DSpaceItem;

public class DSpaceSolrItem
extends DSpaceItem {
    private static final Logger log = LogManager.getLogger(DSpaceSolrItem.class);
    private final String unparsedMD;
    private ItemMetadata metadata;
    private final String handle;
    private final Instant lastMod;
    private final List<ReferenceSet> sets;
    private final boolean deleted;

    public DSpaceSolrItem(SolrDocument doc) {
        log.debug("Creating OAI Item from Solr source");
        this.unparsedMD = (String)doc.getFieldValue("item.compile");
        this.handle = (String)doc.getFieldValue("item.handle");
        this.lastMod = ((Date)doc.getFieldValue("item.lastmodified")).toInstant();
        this.sets = new ArrayList<ReferenceSet>();
        Collection fieldValues = doc.getFieldValues("item.communities");
        if (null != fieldValues) {
            for (Object obj : fieldValues) {
                this.sets.add(new ReferenceSet((String)obj));
            }
        }
        if (null != (fieldValues = doc.getFieldValues("item.collections"))) {
            for (Object obj : fieldValues) {
                this.sets.add(new ReferenceSet((String)obj));
            }
        }
        this.deleted = (Boolean)doc.getFieldValue("item.deleted");
    }

    public ItemMetadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = new ItemMetadata(this.unparsedMD);
        }
        return this.metadata;
    }

    public Date getDatestamp() {
        return Date.from(this.lastMod);
    }

    public List<ReferenceSet> getSets() {
        return this.sets;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    protected String getHandle() {
        return this.handle;
    }
}

