/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.app;

import com.lyncode.xoai.dataprovider.core.Granularity;
import com.lyncode.xoai.dataprovider.exceptions.ConfigurationException;
import com.lyncode.xoai.dataprovider.exceptions.WritingXmlException;
import com.lyncode.xoai.dataprovider.xml.XmlOutputContext;
import com.lyncode.xoai.dataprovider.xml.xoai.Metadata;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.util.SolrUtils;
import org.dspace.utils.DSpace;
import org.dspace.xoai.app.BasicConfiguration;
import org.dspace.xoai.app.XOAIExtensionItemCompilePlugin;
import org.dspace.xoai.exceptions.CompilingException;
import org.dspace.xoai.services.api.CollectionsService;
import org.dspace.xoai.services.api.cache.XOAICacheService;
import org.dspace.xoai.services.api.cache.XOAIItemCacheService;
import org.dspace.xoai.services.api.cache.XOAILastCompilationCacheService;
import org.dspace.xoai.services.api.solr.SolrServerResolver;
import org.dspace.xoai.solr.DSpaceSolrSearch;
import org.dspace.xoai.solr.exceptions.DSpaceSolrException;
import org.dspace.xoai.solr.exceptions.DSpaceSolrIndexerException;
import org.dspace.xoai.util.ItemUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class XOAI {
    private static Logger log = LogManager.getLogger(XOAI.class);
    private final Context context;
    private final boolean verbose;
    private boolean clean;
    @Autowired
    private SolrServerResolver solrServerResolver;
    @Autowired
    private XOAILastCompilationCacheService xoaiLastCompilationCacheService;
    @Autowired
    private XOAIItemCacheService xoaiItemCacheService;
    @Autowired
    private CollectionsService collectionsService;
    private final AuthorizeService authorizeService;
    private final ItemService itemService;
    private static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private List<XOAIExtensionItemCompilePlugin> extensionPlugins;
    private static final String COMMAND_IMPORT = "import";
    private static final String COMMAND_CLEAN_CACHE = "clean-cache";
    private static final String COMMAND_COMPILE_ITEMS = "compile-items";
    private static final String COMMAND_ERASE_COMPILED_ITEMS = "erase-compiled-items";

    private List<String> getFileFormats(Item item) {
        ArrayList<String> formats = new ArrayList<String>();
        try {
            for (Bundle b : this.itemService.getBundles(item, "ORIGINAL")) {
                for (Bitstream bs : b.getBitstreams()) {
                    if (bs == null || formats.contains(bs.getFormat(this.context).getMIMEType())) continue;
                    formats.add(bs.getFormat(this.context).getMIMEType());
                }
            }
        }
        catch (SQLException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return formats;
    }

    public XOAI(Context context, boolean clean, boolean verbose) {
        this.context = context;
        this.clean = clean;
        this.verbose = verbose;
        this.authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.extensionPlugins = new DSpace().getServiceManager().getServicesByType(XOAIExtensionItemCompilePlugin.class);
    }

    public XOAI(Context ctx, boolean hasOption) {
        this.context = ctx;
        this.verbose = hasOption;
        this.authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.extensionPlugins = new DSpace().getServiceManager().getServicesByType(XOAIExtensionItemCompilePlugin.class);
    }

    private void println(String line) {
        System.out.println(line);
    }

    public int index() throws DSpaceSolrIndexerException {
        int result = 0;
        try {
            if (this.clean) {
                this.clearIndex();
                System.out.println("Using full import.");
                result = this.indexAll();
            } else {
                SolrQuery solrParams = new SolrQuery("*:*").addField("item.lastmodified").addSort("item.lastmodified", SolrQuery.ORDER.desc).setRows(Integer.valueOf(1));
                SolrDocumentList results = DSpaceSolrSearch.query(this.solrServerResolver.getServer(), solrParams);
                if (results.getNumFound() == 0L) {
                    System.out.println("There are no indexed documents, using full import.");
                    result = this.indexAll();
                } else {
                    result = this.index(((Date)((SolrDocument)results.get(0)).getFieldValue("item.lastmodified")).toInstant());
                }
            }
            this.solrServerResolver.getServer().commit();
            this.xoaiLastCompilationCacheService.put(Instant.now());
            return result;
        }
        catch (IOException | SolrServerException | DSpaceSolrException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private int index(Instant last) throws DSpaceSolrIndexerException, IOException {
        System.out.println("Incremental import. Searching for documents modified after: " + last.toString());
        try {
            Iterator discoverableChangedItems = this.itemService.findInArchiveOrWithdrawnDiscoverableModifiedSince(this.context, last);
            Iterator nonDiscoverableChangedItems = this.itemService.findInArchiveOrWithdrawnNonDiscoverableModifiedSince(this.context, last);
            Iterator<Item> possiblyChangedItems = this.getItemsWithPossibleChangesBefore(last);
            return this.index(discoverableChangedItems) + this.index(nonDiscoverableChangedItems) + this.index(possiblyChangedItems);
        }
        catch (SQLException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private Iterator<Item> getItemsWithPossibleChangesBefore(Instant last) throws DSpaceSolrIndexerException, IOException {
        try {
            SolrQuery params = new SolrQuery("item.willChangeStatus:true").addField("item.id").setRows(Integer.valueOf(100)).addSort("item.handle", SolrQuery.ORDER.asc);
            SolrClient solrClient = this.solrServerResolver.getServer();
            LinkedList<Item> items = new LinkedList<Item>();
            boolean done = false;
            String cursorMark = "*";
            String nextCursorMark = "";
            while (!done) {
                params.set("cursorMark", new String[]{cursorMark});
                QueryResponse response = solrClient.query((SolrParams)params);
                nextCursorMark = response.getNextCursorMark();
                for (SolrDocument document : response.getResults()) {
                    Item item = (Item)this.itemService.find(this.context, UUID.fromString((String)document.getFieldValue("item.id")));
                    if (!Objects.nonNull(item)) continue;
                    if (Objects.nonNull(item.getLastModified())) {
                        if (!item.getLastModified().isBefore(last)) continue;
                        items.add(item);
                        continue;
                    }
                    log.warn("Skipping item with id " + item.getID());
                }
                if (cursorMark.equals(nextCursorMark)) {
                    done = true;
                }
                cursorMark = nextCursorMark;
            }
            return items.iterator();
        }
        catch (SQLException | SolrServerException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private int indexAll() throws DSpaceSolrIndexerException {
        System.out.println("Full import");
        try {
            Iterator discoverableItems = this.itemService.findInArchiveOrWithdrawnDiscoverableModifiedSince(this.context, null);
            Iterator nonDiscoverableItems = this.itemService.findInArchiveOrWithdrawnNonDiscoverableModifiedSince(this.context, null);
            return this.index(discoverableItems) + this.index(nonDiscoverableItems);
        }
        catch (SQLException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private boolean checkIfIndexed(Item item) throws IOException {
        SolrQuery params = new SolrQuery("item.id:" + item.getID().toString()).addField("item.id");
        try {
            SolrDocumentList documents = DSpaceSolrSearch.query(this.solrServerResolver.getServer(), params);
            return documents.getNumFound() == 1L;
        }
        catch (SolrServerException | DSpaceSolrException e) {
            return false;
        }
    }

    private boolean checkIfVisibleInOAI(Item item) throws IOException {
        SolrQuery params = new SolrQuery("item.id:" + item.getID().toString()).addField("item.public");
        try {
            SolrDocumentList documents = DSpaceSolrSearch.query(this.solrServerResolver.getServer(), params);
            if (documents.getNumFound() == 1L) {
                return (Boolean)((SolrDocument)documents.get(0)).getFieldValue("item.public");
            }
            return false;
        }
        catch (SolrServerException | DSpaceSolrException e) {
            return false;
        }
    }

    private int index(Iterator<Item> iterator) throws DSpaceSolrIndexerException {
        try {
            int i = 0;
            int batchSize = configurationService.getIntProperty("oai.import.batch.size", 1000);
            SolrClient server = this.solrServerResolver.getServer();
            ArrayList<SolrInputDocument> list = new ArrayList<SolrInputDocument>();
            while (iterator.hasNext()) {
                try {
                    Item item = iterator.next();
                    if (item.getHandle() == null) {
                        log.warn("Skipped item without handle: " + item.getID());
                    } else {
                        list.add(this.index(item));
                    }
                    this.context.uncacheEntity((ReloadableEntity)item);
                }
                catch (WritingXmlException | IOException | SQLException | XMLStreamException ex) {
                    log.error(ex.getMessage(), ex);
                }
                if (++i % 1000 == 0 && batchSize != 1000) {
                    System.out.println(i + " items imported so far...");
                }
                if (i % batchSize != 0) continue;
                System.out.println(i + " items imported so far...");
                server.add(list);
                server.commit();
                list.clear();
                try {
                    this.context.uncacheEntities();
                }
                catch (SQLException ex) {
                    log.error("Error uncaching entities", (Throwable)ex);
                }
            }
            System.out.println("Total: " + i + " items");
            if (i > 0) {
                if (!list.isEmpty()) {
                    server.add(list);
                }
                server.commit(true, true);
                list.clear();
            }
            return i;
        }
        catch (IOException | SolrServerException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private Instant getMostRecentModificationDate(Item item) throws SQLException {
        LinkedList<Instant> dates = new LinkedList<Instant>();
        List policies = this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)item, 0);
        for (ResourcePolicy policy : policies) {
            if (policy.getGroup() != null && policy.getGroup().getName().equals("Anonymous")) {
                if (policy.getStartDate() != null) {
                    dates.add(policy.getStartDate().atStartOfDay(ZoneOffset.UTC).toInstant());
                }
                if (policy.getEndDate() != null) {
                    dates.add(policy.getEndDate().atStartOfDay(ZoneOffset.UTC).toInstant());
                }
            }
            this.context.uncacheEntity((ReloadableEntity)policy);
        }
        dates.add(item.getLastModified());
        Collections.sort(dates);
        Instant now = Instant.now();
        Instant lastChange = null;
        for (Instant d : dates) {
            if (!d.isBefore(now)) continue;
            lastChange = d;
        }
        return lastChange;
    }

    private SolrInputDocument index(Item item) throws SQLException, IOException, XMLStreamException, WritingXmlException {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.addField("item.id", (Object)item.getID().toString());
        String handle = item.getHandle();
        doc.addField("item.handle", (Object)handle);
        boolean isEmbargoed = !this.isPublic(item);
        boolean isCurrentlyVisible = this.checkIfVisibleInOAI(item);
        boolean isIndexed = this.checkIfIndexed(item);
        boolean isPublic = isEmbargoed ? (isIndexed ? isCurrentlyVisible : false) : true;
        doc.addField("item.public", (Object)isPublic);
        doc.addField("item.willChangeStatus", (Object)this.willChangeStatus(item));
        doc.addField("item.deleted", (Object)(item.isWithdrawn() || !item.isDiscoverable() || isEmbargoed && isPublic ? 1 : 0));
        doc.addField("item.lastmodified", (Object)SolrUtils.getDateFormatter().format(this.getMostRecentModificationDate(item)));
        if (item.getSubmitter() != null) {
            doc.addField("item.submitter", (Object)item.getSubmitter().getEmail());
        }
        for (Collection collection : item.getCollections()) {
            doc.addField("item.collections", (Object)("col_" + collection.getHandle().replace("/", "_")));
        }
        for (Community community : this.collectionsService.flatParentCommunities(this.context, item)) {
            doc.addField("item.communities", (Object)("com_" + community.getHandle().replace("/", "_")));
        }
        boolean hasBitstream = false;
        for (Object b : item.getBundles("ORIGINAL")) {
            if (b.getBitstreams().size() <= 0) continue;
            hasBitstream = true;
        }
        doc.addField("item.hasbitstream", (Object)hasBitstream);
        List list = this.itemService.getMetadata((DSpaceObject)item, "*", "*", "*", "*");
        for (MetadataValue dc : list) {
            MetadataField field = dc.getMetadataField();
            String key = "metadata." + field.getMetadataSchema().getName() + "." + field.getElement();
            if (field.getQualifier() != null) {
                key = key + "." + field.getQualifier();
            }
            doc.addField(key, (Object)dc.getValue());
            if (dc.getAuthority() == null) continue;
            doc.addField(key + ".authority", (Object)dc.getAuthority());
            doc.addField(key + ".confidence", (Object)("" + dc.getConfidence()));
        }
        for (String f : this.getFileFormats(item)) {
            doc.addField("metadata.dc.format.mimetype", (Object)f);
        }
        if (this.verbose) {
            this.println(String.format("Item %s with handle %s is about to be indexed", item.getID().toString(), handle));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XmlOutputContext xmlContext = XmlOutputContext.emptyContext((OutputStream)out, (Granularity)Granularity.Second);
        Metadata metadata = ItemUtils.retrieveMetadata(this.context, item);
        for (XOAIExtensionItemCompilePlugin plugin : this.extensionPlugins) {
            metadata = plugin.additionalMetadata(this.context, metadata, item);
        }
        metadata.write(xmlContext);
        xmlContext.getWriter().flush();
        xmlContext.getWriter().close();
        doc.addField("item.compile", (Object)out.toString());
        if (this.verbose) {
            this.println(String.format("Item %s with handle %s indexed", item.getID().toString(), handle));
        }
        return doc;
    }

    private boolean willChangeStatus(Item item) throws SQLException {
        List policies = this.authorizeService.getPoliciesActionFilter(this.context, (DSpaceObject)item, 0);
        for (ResourcePolicy policy : policies) {
            if (policy.getGroup() != null && policy.getGroup().getName().equals("Anonymous")) {
                if (policy.getStartDate() != null && policy.getStartDate().isAfter(LocalDate.now(ZoneOffset.UTC))) {
                    return true;
                }
                if (policy.getEndDate() != null && policy.getEndDate().isAfter(LocalDate.now(ZoneOffset.UTC))) {
                    return true;
                }
            }
            this.context.uncacheEntity((ReloadableEntity)policy);
        }
        return false;
    }

    private boolean isPublic(Item item) {
        boolean pub = false;
        try {
            pub = this.authorizeService.authorizeActionBoolean(this.context, (DSpaceObject)item, 0);
        }
        catch (SQLException ex) {
            log.error(ex.getMessage());
        }
        return pub;
    }

    private static boolean getKnownExplanation(Throwable t) {
        if (t instanceof ConnectException) {
            System.err.println("Solr server (" + configurationService.getProperty("oai.solr.url", "") + ") is down, turn it on.");
            return true;
        }
        return false;
    }

    private static boolean searchForReason(Throwable t) {
        if (XOAI.getKnownExplanation(t)) {
            return true;
        }
        if (t.getCause() != null) {
            return XOAI.searchForReason(t.getCause());
        }
        return false;
    }

    private void clearIndex() throws DSpaceSolrIndexerException {
        try {
            System.out.println("Clearing index");
            this.solrServerResolver.getServer().deleteByQuery("*:*");
            this.solrServerResolver.getServer().commit();
            System.out.println("Index cleared");
        }
        catch (IOException | SolrServerException ex) {
            throw new DSpaceSolrIndexerException(ex.getMessage(), ex);
        }
    }

    private static void cleanCache(XOAIItemCacheService xoaiItemCacheService, XOAICacheService xoaiCacheService) throws IOException {
        System.out.println("Purging cached OAI responses.");
        xoaiItemCacheService.deleteAll();
        xoaiCacheService.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws IOException, ConfigurationException {
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext(new Class[]{BasicConfiguration.class});
        XOAICacheService cacheService = (XOAICacheService)applicationContext.getBean(XOAICacheService.class);
        XOAIItemCacheService itemCacheService = (XOAIItemCacheService)applicationContext.getBean(XOAIItemCacheService.class);
        Context ctx = null;
        try {
            DefaultParser parser = new DefaultParser();
            Options options = new Options();
            options.addOption("c", "clear", false, "Clear index before indexing");
            options.addOption("v", "verbose", false, "Verbose output");
            options.addOption("h", "help", false, "Shows some help");
            options.addOption("n", "number", true, "FOR DEVELOPMENT MUST DELETE");
            CommandLine line = parser.parse(options, argv);
            String[] validSolrCommands = new String[]{COMMAND_IMPORT, COMMAND_CLEAN_CACHE};
            String[] validDatabaseCommands = new String[]{COMMAND_CLEAN_CACHE, COMMAND_COMPILE_ITEMS, COMMAND_ERASE_COMPILED_ITEMS};
            boolean solr = true;
            solr = !"database".equals(configurationService.getProperty("oai.storage", "solr"));
            boolean run = false;
            if (line.getArgs().length > 0) {
                if (solr) {
                    if (Arrays.asList(validSolrCommands).contains(line.getArgs()[0])) {
                        run = true;
                    }
                } else if (Arrays.asList(validDatabaseCommands).contains(line.getArgs()[0])) {
                    run = true;
                }
            }
            if (!line.hasOption('h') && run) {
                System.out.println("OAI 2.0 manager action started");
                long start = Instant.now().toEpochMilli();
                String command = line.getArgs()[0];
                if (COMMAND_IMPORT.equals(command)) {
                    ctx = new Context(Context.Mode.READ_ONLY);
                    XOAI indexer = new XOAI(ctx, line.hasOption('c'), line.hasOption('v'));
                    applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)indexer);
                    int imported = indexer.index();
                    if (imported > 0) {
                        XOAI.cleanCache(itemCacheService, cacheService);
                    }
                } else if (COMMAND_CLEAN_CACHE.equals(command)) {
                    XOAI.cleanCache(itemCacheService, cacheService);
                } else if (COMMAND_COMPILE_ITEMS.equals(command)) {
                    ctx = new Context();
                    XOAI indexer = new XOAI(ctx, line.hasOption('v'));
                    applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)indexer);
                    indexer.compile();
                    XOAI.cleanCache(itemCacheService, cacheService);
                } else if (COMMAND_ERASE_COMPILED_ITEMS.equals(command)) {
                    XOAI.cleanCompiledItems(itemCacheService);
                    XOAI.cleanCache(itemCacheService, cacheService);
                }
                System.out.println("OAI 2.0 manager action ended. It took " + (Instant.now().toEpochMilli() - start) / 1000L + " seconds.");
            } else {
                XOAI.usage();
            }
        }
        catch (Throwable ex) {
            if (!XOAI.searchForReason(ex)) {
                ex.printStackTrace();
            }
            log.error(ex.getMessage(), ex);
        }
        finally {
            if (ctx != null && ctx.isValid()) {
                ctx.abort();
            }
        }
    }

    private static void cleanCompiledItems(XOAIItemCacheService itemCacheService) throws IOException {
        System.out.println("Purging compiled items");
        itemCacheService.deleteAll();
    }

    private void compile() throws CompilingException {
        try {
            Iterator iterator;
            Instant last = this.xoaiLastCompilationCacheService.get();
            if (last == null) {
                System.out.println("Retrieving all items to be compiled");
                iterator = this.itemService.findAll(this.context);
            } else {
                System.out.println("Retrieving items modified after " + last + " to be compiled");
                iterator = this.itemService.findByLastModifiedSince(this.context, last);
            }
            while (iterator.hasNext()) {
                Item item = (Item)iterator.next();
                if (this.verbose) {
                    System.out.println("Compiling item with handle: " + item.getHandle());
                }
                this.xoaiItemCacheService.put(item, ItemUtils.retrieveMetadata(this.context, item));
            }
            this.xoaiLastCompilationCacheService.put(Instant.now());
        }
        catch (IOException | SQLException e) {
            throw new CompilingException(e);
        }
        System.out.println("Items compiled");
    }

    private static void usage() {
        boolean solr = true;
        boolean bl = solr = !"database".equals(configurationService.getProperty("oai.storage", "solr"));
        if (solr) {
            System.out.println("OAI Manager Script");
            System.out.println("Syntax: oai <action> [parameters]");
            System.out.println("> Possible actions:");
            System.out.println("     import - To import DSpace items into OAI index and cache system");
            System.out.println("     clean-cache - Cleans the OAI cached responses");
            System.out.println("> Parameters:");
            System.out.println("     -c Clear index (import only)");
            System.out.println("     -v Verbose output");
            System.out.println("     -h Shows this text");
        } else {
            System.out.println("OAI Manager Script");
            System.out.println("Syntax: oai <action> [parameters]");
            System.out.println("> Possible actions:");
            System.out.println("     clean-cache - Cleans the OAI cached responses");
            System.out.println("     compile-items - Compiles all DSpace items");
            System.out.println("     erase-compiled-items - Erase the OAI compiled items");
            System.out.println("> Parameters:");
            System.out.println("     -v Verbose output");
            System.out.println("     -h Shows this text");
        }
    }
}

