/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.solr;

import org.apache.http.client.HttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.dspace.service.impl.HttpConnectionPoolService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class DSpaceSolrServer {
    private static final Logger log = LogManager.getLogger(DSpaceSolrServer.class);
    private static SolrClient _server = null;

    private DSpaceSolrServer() {
    }

    public static SolrClient getServer() throws SolrServerException {
        if (_server == null) {
            ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
            HttpConnectionPoolService httpConnectionPoolService = (HttpConnectionPoolService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("solrHttpConnectionPoolService", HttpConnectionPoolService.class);
            String serverUrl = configurationService.getProperty("oai.solr.url");
            try {
                _server = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(serverUrl).withHttpClient((HttpClient)httpConnectionPoolService.getClient())).build();
                log.debug("OAI Solr Server Initialized");
            }
            catch (Exception e) {
                log.error("Could not initialize OAI Solr Server at " + serverUrl, (Throwable)e);
            }
        }
        return _server;
    }
}

