/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.filter;

import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters.ParameterValue;
import com.lyncode.xoai.dataprovider.xml.xoaiconfig.parameters.SimpleType;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.xoai.data.DSpaceItem;
import org.dspace.xoai.filter.DSpaceFilter;
import org.dspace.xoai.filter.results.SolrFilterResult;

public class DSpaceMetadataExistsFilter
extends DSpaceFilter {
    private static final Logger log = LogManager.getLogger(DSpaceMetadataExistsFilter.class);
    private List<String> fields;

    private List<String> getFields() {
        if (this.fields == null) {
            ParameterValue fields = this.getConfiguration().get("fields");
            if (fields == null) {
                fields = this.getConfiguration().get("field");
            }
            if (fields instanceof SimpleType) {
                this.fields = new ArrayList<String>();
                this.fields.add(((SimpleType)fields).asString());
            } else {
                this.fields = new ArrayList<String>();
                for (ParameterValue val : fields.asParameterList().getValues()) {
                    this.fields.add(val.asSimpleType().asString());
                }
            }
        }
        return this.fields;
    }

    @Override
    public boolean isShown(DSpaceItem item) {
        for (String field : this.getFields()) {
            if (item.getMetadata(field).size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public SolrFilterResult buildSolrQuery() {
        StringBuilder cond = new StringBuilder("(");
        List<String> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            cond.append("metadata.").append(fields.get(i)).append(":[* TO *]");
            if (i >= fields.size() - 1) continue;
            cond.append(" OR ");
        }
        cond.append(")");
        return new SolrFilterResult(cond.toString());
    }
}

