/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.itemmarking.ItemMarkingExtractor;
import org.dspace.app.itemmarking.ItemMarkingInfo;
import org.dspace.app.util.Util;
import org.dspace.app.webui.util.Authenticate;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.DOI;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.DOIService;
import org.dspace.identifier.service.IdentifierService;
import org.dspace.services.factory.DSpaceServicesFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class UIUtil
extends Util {
    private static Boolean useProxies;
    public static final Logger log;
    private static Pattern p;
    private static boolean initialized;
    private static AuthenticationService authenticationService;
    private static EPersonService personService;
    private static IdentifierService identifierService;
    private static DOIService doiService;
    private static HandleService handleService;

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        authenticationService = AuthenticateServiceFactory.getInstance().getAuthenticationService();
        doiService = IdentifierServiceFactory.getInstance().getDOIService();
        handleService = HandleServiceFactory.getInstance().getHandleService();
        identifierService = IdentifierServiceFactory.getInstance().getIdentifierService();
        personService = EPersonServiceFactory.getInstance().getEPersonService();
    }

    public static Context obtainContext(HttpServletRequest request) throws SQLException {
        UIUtil.initialize();
        try {
            if (request.getCharacterEncoding() == null) {
                request.setCharacterEncoding("UTF-8");
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to set encoding to UTF-8.", (Throwable)e);
        }
        Context c = (Context)request.getAttribute("dspace.context");
        if (c == null) {
            c = new Context();
            HttpSession session = request.getSession();
            UUID userID = (UUID)session.getAttribute("dspace.current.user.id");
            if (userID != null) {
                String remAddr = (String)session.getAttribute("dspace.current.remote.addr");
                if (remAddr != null && remAddr.equals(request.getRemoteAddr())) {
                    EPerson e = (EPerson)personService.find(c, userID);
                    Authenticate.loggedIn((Context)c, (HttpServletRequest)request, (EPerson)e);
                } else {
                    log.warn((Object)("POSSIBLE HIJACKED SESSION: request from " + request.getRemoteAddr() + " does not match original session address: " + remAddr + ". Authentication rejected."));
                }
            }
            List groups = authenticationService.getSpecialGroups(c, request);
            for (Group g : groups) {
                c.setSpecialGroup(g.getID());
                log.debug((Object)("Adding Special Group id=" + g.getID().toString()));
            }
            String ip = request.getRemoteAddr();
            if (useProxies == null) {
                useProxies = ConfigurationManager.getBooleanProperty((String)"useProxies", (boolean)false);
            }
            if (useProxies.booleanValue() && request.getHeader("X-Forwarded-For") != null) {
                for (String xfip : request.getHeader("X-Forwarded-For").split(",")) {
                    if (request.getHeader("X-Forwarded-For").contains(ip)) continue;
                    ip = xfip.trim();
                }
            }
            c.setExtraLogInfo("session_id=" + request.getSession().getId() + ":ip_addr=" + ip);
            request.setAttribute("dspace.context", (Object)c);
        }
        Locale sessionLocale = UIUtil.getSessionLocale((HttpServletRequest)request);
        Config.set((HttpSession)request.getSession(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)sessionLocale);
        c.setCurrentLocale(sessionLocale);
        return c;
    }

    public static String[] getItemIdentifier(Context ctx, Item item) throws SQLException {
        UIUtil.initialize();
        String versionHandle = item.getHandle();
        String versionDOI = identifierService.lookup(ctx, (DSpaceObject)item, DOI.class);
        String[] handles = null;
        if (versionHandle != null) {
            handles = new String[]{handleService.resolveToURL(ctx, versionHandle), handleService.getCanonicalForm(versionHandle), versionHandle, "hdl:" + versionHandle};
        }
        String[] dois = null;
        if (versionDOI != null) {
            try {
                dois = new String[]{handleService.resolveToURL(ctx, versionHandle), doiService.DOIToExternalForm(versionDOI), doiService.formatIdentifier(versionDOI).substring("doi:".length()), doiService.formatIdentifier(versionDOI)};
            }
            catch (Exception ex) {
                dois = null;
                log.error((Object)("Unable to format DOI " + versionDOI + ". " + ex.getClass().getName() + ": " + ex.getMessage()));
            }
        }
        if (dois != null && ("doi".equalsIgnoreCase(ConfigurationManager.getProperty((String)"webui.preferred.identifier")) || handles == null)) {
            return dois;
        }
        return handles;
    }

    public static Community getCommunityLocation(HttpServletRequest request) {
        UIUtil.initialize();
        return (Community)request.getAttribute("dspace.community");
    }

    public static Collection getCollectionLocation(HttpServletRequest request) {
        UIUtil.initialize();
        return (Collection)request.getAttribute("dspace.collection");
    }

    public static void storeOriginalURL(HttpServletRequest request) {
        UIUtil.initialize();
        String orig = (String)request.getAttribute("dspace.original.url");
        if (orig == null) {
            String fullURL = request.getRequestURL().toString();
            if (request.getQueryString() != null) {
                fullURL = fullURL + "?" + request.getQueryString();
            }
            request.setAttribute("dspace.original.url", (Object)fullURL);
        }
    }

    public static String getOriginalURL(HttpServletRequest request) {
        UIUtil.initialize();
        UIUtil.storeOriginalURL((HttpServletRequest)request);
        return (String)request.getAttribute("dspace.original.url");
    }

    public static String displayDate(DCDate d, boolean time, boolean localTime, HttpServletRequest request) {
        UIUtil.initialize();
        return d.displayDate(time, localTime, UIUtil.getSessionLocale((HttpServletRequest)request));
    }

    public static String getRequestLogInfo(HttpServletRequest request) {
        UIUtil.initialize();
        StringBuilder report = new StringBuilder();
        report.append("-- URL Was: ").append(UIUtil.getOriginalURL((HttpServletRequest)request)).append("\n").toString();
        report.append("-- Method: ").append(request.getMethod()).append("\n").toString();
        report.append("-- Parameters were:\n");
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("login_password")) {
                report.append("-- ").append(name).append(": *not logged*\n").toString();
                continue;
            }
            report.append("-- ").append(name).append(": \"").append(request.getParameter(name)).append("\"\n");
        }
        return report.toString();
    }

    public static Locale getSessionLocale(HttpServletRequest request) {
        UIUtil.initialize();
        String paramLocale = request.getParameter("locale");
        Locale sessionLocale = null;
        Locale supportedLocale = null;
        if (!StringUtils.isEmpty((String)paramLocale)) {
            sessionLocale = new Locale(paramLocale);
        }
        if (sessionLocale == null) {
            HttpSession session = request.getSession();
            sessionLocale = (Locale)Config.get((HttpSession)session, (String)"javax.servlet.jsp.jstl.fmt.locale");
        }
        if (sessionLocale == null) {
            sessionLocale = request.getLocale();
        }
        if (sessionLocale == null) {
            sessionLocale = I18nUtil.DEFAULTLOCALE;
        }
        supportedLocale = I18nUtil.getSupportedLocale((Locale)sessionLocale);
        return supportedLocale;
    }

    public static void sendAlert(HttpServletRequest request, Exception exception) {
        block8: {
            UIUtil.initialize();
            String logInfo = UIUtil.getRequestLogInfo((HttpServletRequest)request);
            Context c = (Context)request.getAttribute("dspace.context");
            Locale locale = UIUtil.getSessionLocale((HttpServletRequest)request);
            EPerson user = null;
            try {
                String stackTrace;
                String recipient = ConfigurationManager.getProperty((String)"alert.recipient");
                if (!StringUtils.isNotBlank((String)recipient)) break block8;
                Email email = Email.getEmail((String)I18nUtil.getEmailFilename((Locale)locale, (String)"internal_error"));
                email.addRecipient(recipient);
                email.addArgument((Object)ConfigurationManager.getProperty((String)"dspace.url"));
                email.addArgument((Object)new Date());
                email.addArgument((Object)request.getSession().getId());
                email.addArgument((Object)logInfo);
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.toString();
                } else {
                    stackTrace = "No exception";
                }
                email.addArgument((Object)stackTrace);
                try {
                    user = c.getCurrentUser();
                }
                catch (Exception e) {
                    log.warn((Object)"No context, the database might be down or the connection pool exhausted.");
                }
                if (user != null) {
                    email.addArgument((Object)(user.getFullName() + " (" + user.getEmail() + ")"));
                } else {
                    email.addArgument((Object)"Anonymous");
                }
                email.addArgument((Object)request.getRemoteAddr());
                email.send();
            }
            catch (Exception e) {
                log.warn((Object)"Unable to send email alert", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBitstreamDisposition(String filename, HttpServletRequest request, HttpServletResponse response) {
        UIUtil.initialize();
        String name = filename;
        Matcher m = p.matcher(name);
        if (m.find() && !m.group().equals("")) {
            name = m.group();
        }
        try {
            String agent = request.getHeader("USER-AGENT");
            if (null != agent && -1 != agent.indexOf("MSIE")) {
                name = URLEncoder.encode(name, "UTF8");
            } else if (null != agent && -1 != agent.indexOf("Mozilla")) {
                name = MimeUtility.encodeText((String)name, (String)"UTF8", (String)"B");
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            response.setHeader("Content-Disposition", "attachment;filename=" + name);
        }
    }

    public static String getMarkingMarkup(HttpServletRequest hrq, DSpaceObject dso, String markType) throws JspException {
        UIUtil.initialize();
        try {
            String contextPath = hrq.getContextPath();
            Context c = UIUtil.obtainContext((HttpServletRequest)hrq);
            Item item = (Item)dso;
            String mark = markType.replace("mark_", "");
            ItemMarkingExtractor markingExtractor = (ItemMarkingExtractor)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(ItemMarkingExtractor.class.getName() + "." + mark, ItemMarkingExtractor.class);
            if (markingExtractor == null) {
                return "";
            }
            ItemMarkingInfo markInfo = markingExtractor.getItemMarkingInfo(c, item);
            if (markInfo == null) {
                return "";
            }
            StringBuffer markFrag = new StringBuffer();
            String localizedTooltip = null;
            if (markInfo.getTooltip() != null) {
                localizedTooltip = I18nUtil.getMessage((String)markInfo.getTooltip(), (Locale)hrq.getLocale());
            }
            String markLink = markInfo.getLink();
            if (markInfo.getImageName() != null) {
                if (StringUtils.isNotEmpty((String)markLink)) {
                    markFrag.append("<a href=\"").append(contextPath + "/" + markLink).append("\">");
                }
                markFrag.append("<img class=\"" + markType + "_img\" src=\"" + contextPath + "/").append(markInfo.getImageName()).append("\"");
                if (StringUtils.isNotEmpty((String)localizedTooltip)) {
                    markFrag.append(" title=\"").append(localizedTooltip).append("\"");
                }
                markFrag.append("/>");
                if (StringUtils.isNotEmpty((String)markLink)) {
                    markFrag.append("</a>");
                }
            } else if (markInfo.getClassInfo() != null) {
                if (StringUtils.isNotEmpty((String)markLink)) {
                    markFrag.append("<a href=\"").append(contextPath + "/" + markLink).append("\">");
                }
                markFrag.append("<div class=\"" + markType + "_class " + markInfo.getClassInfo() + "\" ");
                if (StringUtils.isNotEmpty((String)localizedTooltip)) {
                    markFrag.append(" title=\"").append(localizedTooltip).append("\"");
                }
                markFrag.append("/>");
                if (StringUtils.isNotEmpty((String)markLink)) {
                    markFrag.append("</a>");
                }
            }
            return markFrag.toString();
        }
        catch (SQLException sqle) {
            throw new JspException(sqle.getMessage(), (Throwable)sqle);
        }
    }

    static {
        log = Logger.getLogger(UIUtil.class);
        p = Pattern.compile("[^/]*$");
        initialized = false;
    }
}

