/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;

public class GroupEditServlet
extends DSpaceServlet {
    private final transient GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private final transient EPersonService personService = EPersonServiceFactory.getInstance().getEPersonService();

    protected void doDSGet(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSPost(c, request, response);
    }

    protected void doDSPost(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        UUID groupID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"group_id");
        Group group = null;
        if (groupID != null) {
            group = (Group)this.groupService.find(c, groupID);
        }
        if (group != null) {
            boolean submit_cancel_delete;
            this.authorizeService.authorizeAction(c, (DSpaceObject)group, 3);
            boolean submit_edit = request.getParameter("submit_edit") != null;
            boolean submit_group_update = request.getParameter("submit_group_update") != null;
            boolean submit_group_delete = request.getParameter("submit_group_delete") != null;
            boolean submit_confirm_delete = request.getParameter("submit_confirm_delete") != null;
            boolean bl = submit_cancel_delete = request.getParameter("submit_cancel_delete") != null;
            if (submit_edit && !submit_group_update && !submit_group_delete) {
                request.setAttribute("group", (Object)group);
                request.setAttribute("members", (Object)group.getMembers());
                request.setAttribute("membergroups", (Object)group.getMemberGroups());
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/group-edit.jsp");
            } else if (submit_group_update) {
                HashSet<UUID> memberSet;
                String newName = request.getParameter("group_name");
                if (!newName.equals(group.getName())) {
                    this.groupService.setName(group, newName);
                    this.groupService.update(c, (DSpaceObject)group);
                }
                List eperson_ids = UIUtil.getUUIDParameters((HttpServletRequest)request, (String)"eperson_id");
                List group_ids = UIUtil.getUUIDParameters((HttpServletRequest)request, (String)"group_ids");
                List members = group.getMembers();
                ArrayList<UUID> memberIdentifiers = new ArrayList<UUID>();
                for (EPerson member : members) {
                    memberIdentifiers.add(member.getID());
                }
                List membergroups = group.getMemberGroups();
                if (eperson_ids != null) {
                    memberSet = new HashSet();
                    HashSet<UUID> epersonIDSet = new HashSet<UUID>();
                    for (EPerson m : members) {
                        memberSet.add(m.getID());
                    }
                    for (UUID e : eperson_ids) {
                        epersonIDSet.add(e);
                    }
                    for (UUID uid : epersonIDSet) {
                        if (memberSet.contains(uid)) continue;
                        this.groupService.addMember(c, group, (EPerson)this.personService.find(c, uid));
                    }
                    for (UUID personId : memberIdentifiers) {
                        if (epersonIDSet.contains(personId)) continue;
                        this.groupService.removeMember(c, group, (EPerson)this.personService.find(c, personId));
                    }
                } else {
                    for (UUID personId : memberIdentifiers) {
                        this.groupService.removeMember(c, group, (EPerson)this.personService.find(c, personId));
                    }
                }
                if (group_ids != null) {
                    memberSet = new HashSet<UUID>();
                    HashSet<UUID> groupIDSet = new HashSet<UUID>();
                    for (Group g : membergroups) {
                        memberSet.add(g.getID());
                    }
                    for (UUID uid : group_ids) {
                        groupIDSet.add(uid);
                    }
                    for (UUID guid : groupIDSet) {
                        if (memberSet.contains(guid)) continue;
                        this.groupService.addMember(c, group, (Group)this.groupService.find(c, guid));
                    }
                    for (Group g : membergroups) {
                        if (groupIDSet.contains(g.getID())) continue;
                        this.groupService.removeMember(c, group, g);
                    }
                } else {
                    for (Group g : membergroups) {
                        this.groupService.removeMember(c, group, g);
                    }
                }
                this.groupService.update(c, (DSpaceObject)group);
                request.setAttribute("group", (Object)group);
                request.setAttribute("members", (Object)group.getMembers());
                request.setAttribute("membergroups", (Object)group.getMemberGroups());
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/group-edit.jsp");
                c.complete();
            } else if (submit_group_delete) {
                request.setAttribute("group", (Object)group);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/group-confirm-delete.jsp");
            } else if (submit_confirm_delete) {
                this.authorizeService.authorizeAction(c, (DSpaceObject)group, 1);
                this.groupService.delete(c, (DSpaceObject)group);
                this.showMainPage(c, request, response);
            } else if (submit_cancel_delete) {
                this.showMainPage(c, request, response);
            } else {
                request.setAttribute("group", (Object)group);
                request.setAttribute("members", (Object)group.getMembers());
                request.setAttribute("membergroups", (Object)group.getMemberGroups());
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/group-edit.jsp");
            }
        } else {
            String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
            if (button.equals("submit_add")) {
                group = this.groupService.create(c);
                this.groupService.setName(group, "new group" + group.getID());
                this.groupService.update(c, (DSpaceObject)group);
                request.setAttribute("group", (Object)group);
                request.setAttribute("members", (Object)group.getMembers());
                request.setAttribute("membergroups", (Object)group.getMemberGroups());
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/group-edit.jsp");
                c.complete();
            } else {
                this.showMainPage(c, request, response);
            }
        }
    }

    private void showMainPage(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        List<Group> groups = new ArrayList();
        boolean isAdmin = this.authorizeService.isAdmin(c);
        boolean isCommunityAdmin = this.authorizeService.isCommunityAdmin(c);
        boolean isCollectionAdmin = this.authorizeService.isCollectionAdmin(c);
        if (!isAdmin && (isCommunityAdmin || isCollectionAdmin)) {
            for (Group group : groups) {
                if (!this.authorizeService.authorizeActionBoolean(c, (DSpaceObject)group, 1) && !this.authorizeService.authorizeActionBoolean(c, (DSpaceObject)group, 3)) continue;
                groups.add(group);
            }
            request.setAttribute("groups", groups);
        } else {
            groups = this.groupService.findAll(c, 1);
            request.setAttribute("groups", groups);
        }
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/group-list.jsp");
        c.complete();
    }
}

