/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.servlet.admin.EditCommunitiesServlet;
import org.dspace.app.webui.util.FileUploadRequest;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;

public class CollectionWizardServlet
extends DSpaceServlet {
    public static final int INITIAL_QUESTIONS = 1;
    public static final int BASIC_INFO = 2;
    public static final int PERMISSIONS = 3;
    public static final int DEFAULT_ITEM = 4;
    public static final int SUMMARY = 5;
    public static final int PERM_READ = 10;
    public static final int PERM_SUBMIT = 11;
    public static final int PERM_WF1 = 12;
    public static final int PERM_WF2 = 13;
    public static final int PERM_WF3 = 14;
    public static final int PERM_ADMIN = 15;
    private static final Logger log = Logger.getLogger(CollectionWizardServlet.class);
    private final transient CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private final transient CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    private final transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final transient GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private final transient EPersonService personService = EPersonServiceFactory.getInstance().getEPersonService();
    private final transient BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private final transient BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    private final transient MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSPost(context, request, response);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            this.processBasicInfo(context, request, response);
            return;
        }
        UUID communityID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"community_id");
        if (communityID != null) {
            Community c = (Community)this.communityService.find(context, communityID);
            if (c == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            Collection newCollection = this.collectionService.create(context, c);
            request.setAttribute("collection", (Object)newCollection);
            if (this.authorizeService.isAdmin(context)) {
                request.setAttribute("sysadmin_button", (Object)Boolean.TRUE);
            }
            try {
                AuthorizeUtil.authorizeManageAdminGroup((Context)context, (Collection)newCollection);
                request.setAttribute("admin_create_button", (Object)Boolean.TRUE);
            }
            catch (AuthorizeException authex) {
                request.setAttribute("admin_create_button", (Object)Boolean.FALSE);
            }
            try {
                AuthorizeUtil.authorizeManageSubmittersGroup((Context)context, (Collection)newCollection);
                request.setAttribute("submitters_button", (Object)Boolean.TRUE);
            }
            catch (AuthorizeException authex) {
                request.setAttribute("submitters_button", (Object)Boolean.FALSE);
            }
            try {
                AuthorizeUtil.authorizeManageWorkflowsGroup((Context)context, (Collection)newCollection);
                request.setAttribute("workflows_button", (Object)Boolean.TRUE);
            }
            catch (AuthorizeException authex) {
                request.setAttribute("workflows_button", (Object)Boolean.FALSE);
            }
            try {
                AuthorizeUtil.authorizeManageTemplateItem((Context)context, (Collection)newCollection);
                request.setAttribute("template_button", (Object)Boolean.TRUE);
            }
            catch (AuthorizeException authex) {
                request.setAttribute("template_button", (Object)Boolean.FALSE);
            }
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/wizard-questions.jsp");
            context.complete();
        } else {
            UUID collectionID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection_id");
            int stage = UIUtil.getIntParameter((HttpServletRequest)request, (String)"stage");
            Collection collection = (Collection)this.collectionService.find(context, collectionID);
            request.setAttribute("collection", (Object)collection);
            if (collection == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            request.setAttribute("collectionService.id", (Object)String.valueOf(collection.getID()));
            switch (stage) {
                case 1: {
                    this.processInitialQuestions(context, request, response, collection);
                    break;
                }
                case 3: {
                    this.processPermissions(context, request, response, collection);
                    break;
                }
                case 4: {
                    this.processDefaultItem(context, request, response, collection);
                    break;
                }
                default: {
                    log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                    JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
                }
            }
        }
    }

    private void processInitialQuestions(Context context, HttpServletRequest request, HttpServletResponse response, Collection collection) throws SQLException, ServletException, IOException, AuthorizeException {
        if (!UIUtil.getBoolParameter((HttpServletRequest)request, (String)"public_read") && this.authorizeService.isAdmin(context)) {
            this.authorizeService.removePoliciesActionFilter(context, (DSpaceObject)collection, 10);
            this.authorizeService.removePoliciesActionFilter(context, (DSpaceObject)collection, 9);
        }
        if (UIUtil.getBoolParameter((HttpServletRequest)request, (String)"submitters")) {
            this.collectionService.createSubmitters(context, collection);
        }
        for (int i = 1; i <= 3; ++i) {
            if (!UIUtil.getBoolParameter((HttpServletRequest)request, (String)("workflow" + i))) continue;
            this.collectionService.createWorkflowGroup(context, collection, i);
        }
        if (UIUtil.getBoolParameter((HttpServletRequest)request, (String)"admins")) {
            this.collectionService.createAdministrators(context, collection);
        }
        if (UIUtil.getBoolParameter((HttpServletRequest)request, (String)"default.item")) {
            this.collectionService.createTemplateItem(context, collection);
        }
        this.collectionService.setMetadata(context, collection, "name", "");
        this.collectionService.update(context, (DSpaceObject)collection);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/wizard-basicinfo.jsp");
        context.complete();
    }

    private void processPermissions(Context context, HttpServletRequest request, HttpServletResponse response, Collection collection) throws SQLException, ServletException, IOException, AuthorizeException {
        int permission = UIUtil.getIntParameter((HttpServletRequest)request, (String)"permission");
        if (UIUtil.getBoolParameter((HttpServletRequest)request, (String)"mitgroup")) {
            Group mitGroup = this.groupService.findByName(context, "MIT Users");
            if (permission == 10) {
                this.authorizeService.addPolicy(context, (DSpaceObject)collection, 10, mitGroup);
                this.authorizeService.addPolicy(context, (DSpaceObject)collection, 9, mitGroup);
            } else {
                this.authorizeService.addPolicy(context, (DSpaceObject)collection, 3, mitGroup);
            }
        }
        Group g = null;
        switch (permission) {
            case 10: {
                g = this.groupService.create(context);
                this.groupService.setName(g, "COLLECTION_" + collection.getID() + "_DEFAULT_ITEM_READ");
                this.authorizeService.addPolicy(context, (DSpaceObject)collection, 10, g);
                this.authorizeService.addPolicy(context, (DSpaceObject)collection, 9, g);
                break;
            }
            case 11: {
                g = collection.getSubmitters();
                break;
            }
            case 12: {
                g = collection.getWorkflowStep1();
                break;
            }
            case 13: {
                g = collection.getWorkflowStep2();
                break;
            }
            case 14: {
                g = collection.getWorkflowStep3();
                break;
            }
            case 15: {
                g = collection.getAdministrators();
            }
        }
        List epersonIds = UIUtil.getUUIDParameters((HttpServletRequest)request, (String)"eperson_id");
        List groupIds = UIUtil.getUUIDParameters((HttpServletRequest)request, (String)"group_ids");
        if (epersonIds != null) {
            for (UUID uid : epersonIds) {
                EPerson eperson = (EPerson)this.personService.find(context, uid);
                if (eperson == null) continue;
                this.groupService.addMember(context, g, eperson);
            }
        }
        if (groupIds != null) {
            for (UUID uid : groupIds) {
                Group group = (Group)this.groupService.find(context, uid);
                if (group == null) continue;
                this.groupService.addMember(context, g, group);
            }
        }
        this.groupService.update(context, (DSpaceObject)g);
        this.showNextPage(context, request, response, collection, permission);
        context.complete();
    }

    private void processBasicInfo(Context context, HttpServletRequest request, HttpServletResponse response) throws SQLException, ServletException, IOException, AuthorizeException {
        try {
            File temp;
            FileUploadRequest wrapper = new FileUploadRequest(request);
            Collection collection = (Collection)this.collectionService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)wrapper, (String)"collection_id"));
            if (collection == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)wrapper)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            this.collectionService.setMetadata(context, collection, "name", wrapper.getParameter("name"));
            this.collectionService.setMetadata(context, collection, "short_description", wrapper.getParameter("short_description"));
            this.collectionService.setMetadata(context, collection, "introductory_text", wrapper.getParameter("introductory_text"));
            this.collectionService.setMetadata(context, collection, "copyright_text", wrapper.getParameter("copyright_text"));
            this.collectionService.setMetadata(context, collection, "side_bar_text", wrapper.getParameter("side_bar_text"));
            this.collectionService.setMetadata(context, collection, "provenance_description", wrapper.getParameter("provenance_description"));
            String license = wrapper.getParameter("license");
            if (!StringUtils.isEmpty((String)license)) {
                collection.setLicense(context, license);
            }
            if ((temp = wrapper.getFile("file")) != null) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(temp));
                Bitstream logoBS = this.collectionService.setLogo(context, collection, (InputStream)is);
                String noPath = wrapper.getFilesystemName("file");
                while (noPath.indexOf(47) > -1) {
                    noPath = noPath.substring(noPath.indexOf(47) + 1);
                }
                while (noPath.indexOf(92) > -1) {
                    noPath = noPath.substring(noPath.indexOf(92) + 1);
                }
                logoBS.setName(context, noPath);
                logoBS.setSource(context, wrapper.getFilesystemName("file"));
                BitstreamFormat bf = this.bitstreamFormatService.guessFormat(context, logoBS);
                logoBS.setFormat(context, bf);
                this.authorizeService.addPolicy(context, (DSpaceObject)logoBS, 1, context.getCurrentUser());
                this.bitstreamService.update(context, (DSpaceObject)logoBS);
                if (!temp.delete()) {
                    log.trace((Object)"Unable to delete temporary file");
                }
            }
            this.collectionService.update(context, (DSpaceObject)collection);
            this.showNextPage(context, request, response, collection, 2);
            context.complete();
        }
        catch (FileUploadBase.FileSizeLimitExceededException ex) {
            log.warn((Object)"Upload exceeded upload.max");
            JSPManager.showFileSizeLimitExceededError((HttpServletRequest)request, (HttpServletResponse)response, (String)ex.getMessage(), (long)ex.getActualSize(), (long)ex.getPermittedSize());
        }
    }

    private void processDefaultItem(Context context, HttpServletRequest request, HttpServletResponse response, Collection collection) throws SQLException, ServletException, IOException, AuthorizeException {
        Item item = collection.getTemplateItem();
        for (int i = 0; i < 10; ++i) {
            int dcTypeID = UIUtil.getIntParameter((HttpServletRequest)request, (String)("dctype_" + i));
            String value = request.getParameter("value_" + i);
            String lang = request.getParameter("lang_" + i);
            if (dcTypeID == -1 || value == null || value.equals("")) continue;
            MetadataField field = this.metadataFieldService.find(context, dcTypeID);
            MetadataSchema schema = field.getMetadataSchema();
            this.itemService.addMetadata(context, (DSpaceObject)item, schema.getName(), field.getElement(), field.getQualifier(), lang, value);
        }
        this.itemService.update(context, (DSpaceObject)item);
        this.showNextPage(context, request, response, collection, 4);
        context.complete();
    }

    private void showNextPage(Context context, HttpServletRequest request, HttpServletResponse response, Collection collection, int stage) throws SQLException, ServletException, IOException, AuthorizeException {
        request.setAttribute("collection", (Object)collection);
        if (this.groupService.findByName(context, "MIT Users") != null) {
            request.setAttribute("mitgroup", (Object)Boolean.TRUE);
        }
        log.debug((Object)LogManager.getHeader((Context)context, (String)"nextpage", (String)("stage=" + stage)));
        switch (stage) {
            case 2: {
                List anonReadPols = this.authorizeService.getPoliciesActionFilter(context, (DSpaceObject)collection, 10);
                if (anonReadPols.size() == 0) {
                    request.setAttribute("permission", (Object)10);
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/wizard-permissions.jsp");
                    break;
                }
            }
            case 10: {
                if (collection.getSubmitters() != null) {
                    request.setAttribute("permission", (Object)11);
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/wizard-permissions.jsp");
                    break;
                }
            }
            case 11: {
                if (collection.getWorkflowStep1() != null) {
                    request.setAttribute("permission", (Object)12);
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/wizard-permissions.jsp");
                    break;
                }
            }
            case 12: {
                if (collection.getWorkflowStep2() != null) {
                    request.setAttribute("permission", (Object)13);
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/wizard-permissions.jsp");
                    break;
                }
            }
            case 13: {
                if (collection.getWorkflowStep3() != null) {
                    request.setAttribute("permission", (Object)14);
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/wizard-permissions.jsp");
                    break;
                }
            }
            case 14: {
                if (collection.getAdministrators() != null) {
                    request.setAttribute("permission", (Object)15);
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/wizard-permissions.jsp");
                    break;
                }
            }
            case 15: {
                if (collection.getTemplateItem() != null) {
                    List types = this.metadataFieldService.findAll(context);
                    request.setAttribute("dctypes", (Object)types);
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/wizard-default-item.jsp");
                    break;
                }
            }
            case 4: {
                if (collection != null) {
                    List communities = collection.getCommunities();
                    request.setAttribute("community", communities.get(0));
                    EditCommunitiesServlet.storeAuthorizeAttributeCollectionEdit((Context)context, (HttpServletRequest)request, (Collection)collection);
                }
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/edit-collection.jsp");
            }
        }
    }
}

