/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;

public class ItemPreviewTag
extends TagSupport {
    private Item item;
    private static final long serialVersionUID = -5535762797556685631L;
    private final transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public int doStartTag() throws JspException {
        if (!ConfigurationManager.getBooleanProperty((String)"webui.preview.enabled")) {
            return 0;
        }
        try {
            this.showPreview();
        }
        catch (SQLException sqle) {
            throw new JspException((Throwable)sqle);
        }
        catch (IOException ioe) {
            throw new JspException((Throwable)ioe);
        }
        return 0;
    }

    public void setItem(Item itemIn) {
        this.item = itemIn;
    }

    private void showPreview() throws SQLException, IOException {
        JspWriter out = this.pageContext.getOut();
        List bundles = this.itemService.getBundles(this.item, "BRANDED_PREVIEW");
        if (bundles.size() > 0) {
            int i;
            String dcValue;
            List bitstreams = ((Bundle)bundles.get(0)).getBitstreams();
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            out.println("<br/><p align=\"center\">");
            Bitstream bitstream = (Bitstream)bitstreams.get(0);
            out.println("<img src=\"" + request.getContextPath() + "/retrieve/" + bitstream.getID() + "/" + UIUtil.encodeBitstreamName((String)bitstream.getName(), (String)"UTF-8") + "\"/>");
            String s = ConfigurationManager.getProperty((String)"webui.preview.dc");
            if (s != null && (dcValue = (i = s.indexOf(46)) == -1 ? this.itemService.getMetadataFirstValue((DSpaceObject)this.item, "dc", s, "*", "*") : this.itemService.getMetadataFirstValue((DSpaceObject)this.item, "dc", s.substring(0, 1), s.substring(i + 1), "*")) != null) {
                out.println("<br/>" + dcValue);
            }
            out.println("</p>");
        }
    }

    public void release() {
        this.item = null;
    }
}

