/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.components;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.VersionUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.DOI;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.DOIService;
import org.dspace.identifier.service.IdentifierService;
import org.dspace.plugin.ItemHomeProcessor;
import org.dspace.plugin.PluginException;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;

public class VersioningItemHome
implements ItemHomeProcessor {
    private static Logger log = Logger.getLogger(VersioningItemHome.class);
    private DOIService doiService = IdentifierServiceFactory.getInstance().getDOIService();
    private HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private IdentifierService identifierService = IdentifierServiceFactory.getInstance().getIdentifierService();
    private VersionHistoryService versionHistoryService;
    private VersioningService versioningService;
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private ConfigurationService configurationService;

    public VersioningItemHome() {
        this.versioningService = VersionServiceFactory.getInstance().getVersionService();
        this.versionHistoryService = VersionServiceFactory.getInstance().getVersionHistoryService();
        this.configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    }

    public void process(Context context, HttpServletRequest request, HttpServletResponse response, Item item) throws PluginException, AuthorizeException {
        boolean versioningEnabled = (Boolean)this.configurationService.getPropertyAsType("versioning.enabled", (Object)false);
        boolean submitterCanCreateNewVersion = (Boolean)this.configurationService.getPropertyAsType("versioning.submitterCanCreateNewVersion", (Object)false);
        boolean newVersionAvailable = false;
        boolean showVersionWorkflowAvailable = false;
        boolean hasVersionButton = false;
        boolean hasVersionHistory = false;
        VersionHistory history = null;
        ArrayList<Version> historyVersions = new ArrayList<Version>();
        String latestVersionIdentifier = null;
        if (versioningEnabled) {
            Version latestVersion;
            try {
                if (this.itemService.canEdit(context, item)) {
                    if (this.versionHistoryService.isLastVersion(context, item) && item.isArchived()) {
                        hasVersionButton = true;
                    }
                } else if (submitterCanCreateNewVersion && this.versionHistoryService.isLastVersion(context, item) && item.isArchived() && this.itemService.canCreateNewVersion(context, item)) {
                    hasVersionButton = true;
                }
                if (this.versionHistoryService.hasVersionHistory(context, item)) {
                    hasVersionHistory = true;
                    history = this.versionHistoryService.findByItem(context, item);
                    for (Version versRow : this.versioningService.getVersionsByHistory(context, history)) {
                        if (VersionUtil.isItemInSubmission((Context)context, (Item)versRow.getItem())) continue;
                        historyVersions.add(versRow);
                    }
                }
            }
            catch (SQLException e) {
                throw new PluginException(e.getMessage());
            }
            try {
                latestVersion = VersionUtil.checkLatestVersion((Context)context, (Item)item);
            }
            catch (SQLException e) {
                throw new PluginException(e.getMessage());
            }
            if (latestVersion != null && latestVersion.getItem() != null && !latestVersion.getItem().getID().equals(item.getID())) {
                Item latestVersionItem = latestVersion.getItem();
                if (latestVersionItem.isArchived()) {
                    String latestVersionDOI;
                    newVersionAvailable = true;
                    String latestVersionHandle = latestVersionItem.getHandle();
                    if (latestVersionHandle != null) {
                        latestVersionIdentifier = this.handleService.getCanonicalForm(latestVersionHandle);
                    }
                    if ((latestVersionDOI = this.identifierService.lookup(context, (DSpaceObject)latestVersionItem, DOI.class)) != null) {
                        try {
                            latestVersionDOI = this.doiService.DOIToExternalForm(latestVersionDOI);
                        }
                        catch (IdentifierException ex) {
                            log.error((Object)("Unable to convert DOI '" + latestVersionDOI + "' into external form: " + ex.toString()), (Throwable)ex);
                            throw new PluginException((Throwable)ex);
                        }
                    }
                    if ("doi".equalsIgnoreCase(this.configurationService.getProperty("webui.preferred.identifier")) && latestVersionDOI != null) {
                        latestVersionIdentifier = latestVersionDOI;
                    }
                } else {
                    showVersionWorkflowAvailable = true;
                }
            }
        }
        request.setAttribute("versioning.enabled", (Object)versioningEnabled);
        request.setAttribute("versioning.hasversionbutton", (Object)hasVersionButton);
        request.setAttribute("versioning.hasversionhistory", (Object)hasVersionHistory);
        request.setAttribute("versioning.history", history);
        request.setAttribute("versioning.historyversions", historyVersions);
        request.setAttribute("versioning.newversionavailable", (Object)newVersionAvailable);
        request.setAttribute("versioning.showversionwfavailable", (Object)showVersionWorkflowAvailable);
        request.setAttribute("versioning.latest_version_identifier", latestVersionIdentifier);
    }
}

