/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowItemService;
import org.dspace.workflow.factory.WorkflowServiceFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class VersionUtil {
    private static boolean initialezed = false;
    private static ItemService itemService;
    private static AuthorizeService authorizeService;
    private static VersioningService versioningService;
    private static VersionHistoryService versionHistoryService;
    private static WorkspaceItemService workspaceItemService;
    private static WorkflowItemService workflowItemService;

    private static synchronized void initialize() {
        initialezed = true;
        itemService = ContentServiceFactory.getInstance().getItemService();
        authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        versionHistoryService = VersionServiceFactory.getInstance().getVersionHistoryService();
        versioningService = VersionServiceFactory.getInstance().getVersionService();
        workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
        workflowItemService = WorkflowServiceFactory.getInstance().getWorkflowItemService();
    }

    public static Integer processCreateNewVersion(Context context, UUID itemID, String summary) throws SQLException, AuthorizeException, IOException {
        VersionUtil.initialize();
        try {
            Item item = (Item)itemService.find(context, itemID);
            if (authorizeService.authorizeActionBoolean(context, (DSpaceObject)item, 1) || itemService.canEdit(context, item) || itemService.canCreateNewVersion(context, item)) {
                VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
                Version version = versioningService.createNewVersion(context, item, summary);
                WorkspaceItem wsi = workspaceItemService.findByItem(context, version.getItem());
                return wsi.getID();
            }
        }
        catch (Exception ex) {
            context.abort();
            throw new RuntimeException(ex);
        }
        return null;
    }

    public static void processUpdateVersion(Context context, UUID itemID, String summary) throws SQLException, AuthorizeException, IOException {
        VersionUtil.initialize();
        try {
            Item item = (Item)itemService.find(context, itemID);
            if (authorizeService.authorizeActionBoolean(context, (DSpaceObject)item, 1)) {
                versioningService.updateVersion(context, item, summary);
            }
        }
        catch (Exception ex) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw new RuntimeException(ex);
        }
    }

    public static void processRestoreVersion(Context context, int versionID, String summary) throws SQLException, AuthorizeException, IOException {
        VersionUtil.initialize();
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        Version version = versioningService.getVersion(context, versionID);
        versioningService.restoreVersion(context, version, summary);
    }

    public static Item processDeleteVersions(Context context, UUID itemId, String[] versionIDs) throws SQLException, AuthorizeException, IOException {
        VersionUtil.initialize();
        try {
            Item item = (Item)itemService.find(context, itemId);
            VersionHistory versionHistory = versionHistoryService.findByItem(context, item);
            for (String versionID : versionIDs) {
                Version version = versioningService.getVersion(context, Integer.parseInt(versionID));
                versioningService.removeVersion(context, version);
            }
            Version latestVersion = versionHistoryService.getLatestVersion(context, versionHistory);
            if (latestVersion == null) {
                return null;
            }
            return latestVersion.getItem();
        }
        catch (Exception ex) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw new RuntimeException(ex);
        }
    }

    public static Version checkLatestVersion(Context context, Item item) throws SQLException {
        VersionUtil.initialize();
        VersionHistory history = versionHistoryService.findByItem(context, item);
        if (history != null) {
            List allVersions = versioningService.getVersionsByHistory(context, history);
            for (Version version : allVersions) {
                if (!version.getItem().isArchived() && !authorizeService.isAdmin(context, (DSpaceObject)item.getOwningCollection())) continue;
                return version;
            }
        }
        return null;
    }

    public static boolean isItemInSubmission(Context context, Item item) throws SQLException {
        VersionUtil.initialize();
        WorkspaceItem workspaceItem = workspaceItemService.findByItem(context, item);
        WorkflowItem workflowItem = workflowItemService.findByItem(context, item);
        return workspaceItem != null || workflowItem != null;
    }

    @Deprecated
    public static String[] addItemIdentifier(Item item, Version version) {
        VersionUtil.initialize();
        String[] result = null;
        String itemHandle = version.getItem().getHandle();
        List identifiers = itemService.getMetadata((DSpaceObject)item, "dc", "identifier", null, "*");
        String itemIdentifier = null;
        if (identifiers != null && identifiers.size() > 0) {
            itemIdentifier = ((MetadataValue)identifiers.get(0)).getValue();
        }
        result = itemIdentifier != null ? new String[]{"/resource/" + itemIdentifier, itemIdentifier} : new String[]{"/handle/" + itemHandle, itemHandle};
        return result;
    }

    public static String getSummary(Context context, String stringVersionID) {
        VersionUtil.initialize();
        String result = "";
        try {
            Integer versionID = Integer.parseInt(stringVersionID);
            VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
            Version version = versioningService.getVersion(context, versionID.intValue());
            if (version != null) {
                result = version.getSummary();
            }
        }
        catch (Exception ex) {
            if (context != null && context.isValid()) {
                context.abort();
            }
            throw new RuntimeException(ex);
        }
        return result;
    }
}

