/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.RequestInfo;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;

/*
 * Exception performing whole class analysis ignored.
 */
public class Authenticate {
    private static Logger log = Logger.getLogger(Authenticate.class);
    private static boolean initialized = false;
    private static AuthenticationService authenticationService;
    private static AuthorizeService authorizeService;
    private static EPersonService personService;

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        authenticationService = AuthenticateServiceFactory.getInstance().getAuthenticationService();
        authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
        personService = EPersonServiceFactory.getInstance().getEPersonService();
    }

    public static HttpServletRequest getRealRequest(HttpServletRequest request) {
        Authenticate.initialize();
        HttpSession session = request.getSession();
        if (session.getAttribute("resuming.request") != null) {
            RequestInfo requestInfo = (RequestInfo)session.getAttribute("interrupted.request.info");
            HttpServletRequest actualRequest = requestInfo == null ? request : requestInfo.wrapRequest(request);
            session.removeAttribute("resuming.request");
            session.removeAttribute("interrupted.request.info");
            session.removeAttribute("interrupted.request.url");
            return actualRequest;
        }
        return request;
    }

    public static void resumeInterruptedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Authenticate.initialize();
        HttpSession session = request.getSession();
        String originalURL = (String)session.getAttribute("interrupted.request.url");
        if (originalURL == null) {
            originalURL = request.getContextPath() + "/mydspace";
        } else {
            session.setAttribute("resuming.request", (Object)Boolean.TRUE);
        }
        response.sendRedirect(response.encodeRedirectURL(originalURL));
    }

    public static boolean startAuthentication(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Authenticate.initialize();
        HttpSession session = request.getSession();
        if (authenticationService.authenticateImplicit(context, null, null, null, request) == 1) {
            Authenticate.loggedIn((Context)context, (HttpServletRequest)request, (EPerson)context.getCurrentUser());
            log.info((Object)LogManager.getHeader((Context)context, (String)"login", (String)"type=implicit"));
            if (context.getCurrentUser() != null) {
                Authenticate.resumeInterruptedRequest((HttpServletRequest)request, (HttpServletResponse)response);
                return false;
            }
            return true;
        }
        response.addDateHeader("expires", 1L);
        response.addHeader("Pragma", "no-cache");
        response.addHeader("Cache-control", "no-store");
        RequestInfo info = new RequestInfo(request);
        session.setAttribute("interrupted.request.info", (Object)info);
        session.setAttribute("interrupted.request.url", (Object)UIUtil.getOriginalURL((HttpServletRequest)request));
        Iterator ai = authenticationService.authenticationMethodIterator();
        int count = 0;
        String url = null;
        while (ai.hasNext()) {
            AuthenticationMethod am = (AuthenticationMethod)ai.next();
            String s = am.loginPageURL(context, request, response);
            if (s == null) continue;
            url = s;
            ++count;
        }
        if (count == 1) {
            response.sendRedirect(url);
        } else {
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/login/chooser.jsp");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loggedIn(Context context, HttpServletRequest request, EPerson eperson) {
        Authenticate.initialize();
        HttpSession session = request.getSession();
        if (!session.isNew() && session.getAttribute("dspace.current.user.id") == null) {
            Locale sessionLocale = UIUtil.getSessionLocale((HttpServletRequest)request);
            RequestInfo requestInfo = (RequestInfo)session.getAttribute("interrupted.request.info");
            String requestUrl = (String)session.getAttribute("interrupted.request.url");
            if (ConfigurationManager.getBooleanProperty((String)"webui.session.invalidate", (boolean)true)) {
                session.invalidate();
            }
            session = request.getSession();
            if (sessionLocale != null) {
                Config.set((HttpSession)request.getSession(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)sessionLocale);
            }
            if (requestInfo != null && requestUrl != null) {
                session.setAttribute("interrupted.request.info", (Object)requestInfo);
                session.setAttribute("interrupted.request.url", (Object)requestUrl);
            }
        }
        context.setCurrentUser(eperson);
        boolean isAdmin = false;
        boolean isCommunityAdmin = false;
        boolean isCollectionAdmin = false;
        try {
            isAdmin = authorizeService.isAdmin(context);
            isCommunityAdmin = authorizeService.isCommunityAdmin(context);
            isCollectionAdmin = authorizeService.isCollectionAdmin(context);
        }
        catch (SQLException se) {
            log.warn((Object)("Unable to use AuthorizeManager " + se));
        }
        finally {
            request.setAttribute("is.admin", (Object)isAdmin);
            request.setAttribute("is.communityAdmin", (Object)isCommunityAdmin);
            request.setAttribute("is.collectionAdmin", (Object)isCollectionAdmin);
        }
        request.setAttribute("dspace.current.user", (Object)eperson);
        session.setAttribute("dspace.current.user.id", (Object)eperson.getID());
        session.setAttribute("dspace.current.remote.addr", (Object)request.getRemoteAddr());
    }

    public static void loggedOut(Context context, HttpServletRequest request) throws SQLException {
        Authenticate.initialize();
        HttpSession session = request.getSession();
        context.setCurrentUser(null);
        request.removeAttribute("is.admin");
        request.removeAttribute("dspace.current.user");
        session.removeAttribute("dspace.current.user.id");
        UUID previousUserID = (UUID)session.getAttribute("dspace.previous.user.id");
        Locale sessionLocale = UIUtil.getSessionLocale((HttpServletRequest)request);
        if (ConfigurationManager.getBooleanProperty((String)"webui.session.invalidate", (boolean)true) && previousUserID != null) {
            session.invalidate();
        }
        if (sessionLocale != null) {
            Config.set((HttpSession)request.getSession(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)sessionLocale);
        }
        if (previousUserID != null) {
            session.removeAttribute("dspace.previous.user.id");
            EPerson ePerson = (EPerson)personService.find(context, previousUserID);
            Authenticate.loggedIn((Context)context, (HttpServletRequest)request, (EPerson)ePerson);
        }
    }
}

