/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.webui.submit.JSPStep;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.submit.lookup.SubmissionLookupService;

public class JSPStartSubmissionLookupStep
extends JSPStep {
    private static final String START_LOOKUP_JSP = "/submit/start-lookup-submission.jsp";
    private static Logger log = Logger.getLogger(JSPStartSubmissionLookupStep.class);
    SubmissionLookupService slService = (SubmissionLookupService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(SubmissionLookupService.class.getCanonicalName(), SubmissionLookupService.class);
    private CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private final String DEFAULT_COLLECTION_ID = "-1";

    public void doPreProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        if (request.getAttribute("no.collection") == null || !((Boolean)request.getAttribute("no.collection")).booleanValue()) {
            request.setAttribute("s_uuid", (Object)UUID.randomUUID().toString());
        }
        UUID collection_id = null;
        if (!"-1".equals(request.getParameter("collection"))) {
            collection_id = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection");
        }
        if (collection_id == null && !"-1".equals(request.getParameter("collectionid"))) {
            collection_id = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collectionid");
        }
        Collection col = null;
        if (collection_id != null) {
            col = (Collection)this.collectionService.find(context, collection_id);
        }
        if (col != null) {
            log.debug((Object)("Select Collection page skipped, since a Collection ID was already found.  Collection ID=" + collection_id));
        } else {
            Community com = UIUtil.getCommunityLocation((HttpServletRequest)request);
            List collections = com != null ? this.collectionService.findAuthorized(context, com, 3) : this.collectionService.findAuthorizedOptimized(context, 3);
            request.setAttribute("collections", (Object)collections);
            if (collection_id != null) {
                request.setAttribute("collection_id", (Object)collection_id);
            } else {
                request.setAttribute("collection_id", (Object)"-1");
            }
            request.setAttribute("collectionID", (Object)collection_id);
            Map identifiers2providers = this.slService.getProvidersIdentifiersMap();
            List searchProviders = this.slService.getSearchProviders();
            List fileProviders = this.slService.getFileProviders();
            request.setAttribute("identifiers2providers", (Object)identifiers2providers);
            request.setAttribute("searchProviders", (Object)searchProviders);
            request.setAttribute("fileLoaders", (Object)fileProviders);
            request.setAttribute("identifiers", (Object)this.slService.getIdentifiers());
            JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)START_LOOKUP_JSP);
        }
    }

    public void doPostProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int status) throws ServletException, IOException, SQLException, AuthorizeException {
        if (status == 1) {
            request.setAttribute("no.collection", (Object)new Boolean(true));
            this.doPreProcessing(context, request, response, subInfo);
        } else if (status == 2) {
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)request.getParameter("collectionid"), (int)3);
        } else if (status == 3) {
            request.setAttribute("no.suuid", (Object)new Boolean(true));
            this.doPreProcessing(context, request, response, subInfo);
        } else if (status == 4) {
            request.setAttribute("expired", (Object)new Boolean(true));
            this.doPreProcessing(context, request, response, subInfo);
        } else if (status != 0) {
            request.setAttribute("no.suuid", (Object)new Boolean(true));
            this.doPreProcessing(context, request, response, subInfo);
        }
    }

    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        return "";
    }
}

