/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;

public class MetadataFieldRegistryServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(MetadataFieldRegistryServlet.class);
    private static final String clazz = "org.dspace.app.webui.servlet.admin.MetadataFieldRegistryServlet";
    private final transient MetadataFieldService fieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    private final transient MetadataSchemaService schemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        MetadataSchema schemaID = this.getSchema(context, request);
        this.showTypes(context, request, response, schemaID);
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        block23: {
            String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
            MetadataSchema schema = this.getSchema(context, request);
            Locale locale = context.getCurrentLocale();
            ResourceBundle labels = ResourceBundle.getBundle("Messages", locale);
            String element = request.getParameter("element");
            String scope = request.getParameter("scope_note");
            String qual = request.getParameter("qualifier");
            if ("".equals(qual)) {
                qual = null;
            }
            if ("submit_update".equals(button)) {
                if (!this.sanityCheck(request, labels)) {
                    this.showTypes(context, request, response, schema);
                    context.abort();
                    return;
                }
                try {
                    MetadataField dc = this.fieldService.find(context, UIUtil.getIntParameter((HttpServletRequest)request, (String)"dc_type_id"));
                    dc.setElement(element);
                    dc.setQualifier(qual);
                    dc.setScopeNote(scope);
                    this.fieldService.update(context, dc);
                    this.showTypes(context, request, response, schema);
                    context.complete();
                }
                catch (NonUniqueMetadataException e) {
                    context.abort();
                    log.error((Object)e);
                }
            } else if ("submit_add".equals(button)) {
                if (!this.sanityCheck(request, labels)) {
                    this.showTypes(context, request, response, schema);
                    context.abort();
                    return;
                }
                try {
                    MetadataField dc = this.fieldService.create(context, schema, element, qual, scope);
                    this.fieldService.update(context, dc);
                    this.showTypes(context, request, response, schema);
                    context.complete();
                }
                catch (NonUniqueMetadataException e) {
                    log.warn((Object)e);
                    request.setAttribute("error", (Object)labels.getString("org.dspace.app.webui.servlet.admin.MetadataFieldRegistryServlet.createfailed"));
                    this.showTypes(context, request, response, schema);
                    context.abort();
                }
            } else if ("submit_delete".equals(button)) {
                MetadataField dc = this.fieldService.find(context, UIUtil.getIntParameter((HttpServletRequest)request, (String)"dc_type_id"));
                request.setAttribute("type", (Object)dc);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/confirm-delete-mdfield.jsp");
            } else if ("submit_confirm_delete".equals(button)) {
                MetadataField dc = this.fieldService.find(context, UIUtil.getIntParameter((HttpServletRequest)request, (String)"dc_type_id"));
                try {
                    this.fieldService.delete(context, dc);
                    request.setAttribute("failed", (Object)Boolean.FALSE);
                    this.showTypes(context, request, response, schema);
                }
                catch (Exception e) {
                    request.setAttribute("type", (Object)dc);
                    request.setAttribute("failed", (Object)true);
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/confirm-delete-mdfield.jsp");
                }
                context.complete();
            } else if ("submit_move".equals(button)) {
                try {
                    int schemaID = Integer.parseInt(request.getParameter("dc_dest_schema_id"));
                    String[] param = request.getParameterValues("dc_field_id");
                    if (schemaID == 0 || param == null) {
                        request.setAttribute("error", (Object)labels.getString("org.dspace.app.webui.servlet.admin.MetadataFieldRegistryServlet.movearguments"));
                        this.showTypes(context, request, response, this.schemaService.find(context, schemaID));
                        context.abort();
                        break block23;
                    }
                    schema = this.schemaService.find(context, schemaID);
                    for (int ii = 0; ii < param.length; ++ii) {
                        int fieldID = Integer.parseInt(param[ii]);
                        MetadataField field = this.fieldService.find(context, fieldID);
                        field.setMetadataSchema(schema);
                        this.fieldService.update(context, field);
                    }
                    context.complete();
                    response.sendRedirect(request.getContextPath() + "/dspace-admin/metadata-schema-registry?dc_schema_id=" + schemaID);
                }
                catch (NonUniqueMetadataException e) {
                    log.warn((Object)e);
                    request.setAttribute("error", (Object)labels.getString("org.dspace.app.webui.servlet.admin.MetadataFieldRegistryServlet.movefailed"));
                    this.showTypes(context, request, response, schema);
                    context.abort();
                }
            } else {
                this.showTypes(context, request, response, schema);
            }
        }
    }

    private MetadataSchema getSchema(Context context, HttpServletRequest request) throws SQLException {
        int schemaID = Integer.parseInt(request.getParameter("dc_schema_id"));
        return this.schemaService.find(context, schemaID);
    }

    private void showTypes(Context context, HttpServletRequest request, HttpServletResponse response, MetadataSchema schema) throws ServletException, IOException, SQLException, AuthorizeException {
        List types = this.fieldService.findAllInSchema(context, schema);
        request.setAttribute("types", (Object)types);
        request.setAttribute("schema", (Object)schema);
        List schemas = this.schemaService.findAll(context);
        request.setAttribute("schemas", (Object)schemas);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/list-metadata-fields.jsp");
    }

    private boolean sanityCheck(HttpServletRequest request, ResourceBundle labels) {
        String element = request.getParameter("element");
        if (element.length() == 0) {
            return this.error(request, labels.getString("org.dspace.app.webui.servlet.admin.MetadataFieldRegistryServlet.elemempty"));
        }
        for (int ii = 0; ii < element.length(); ++ii) {
            if (element.charAt(ii) != '.' && element.charAt(ii) != '_' && element.charAt(ii) != ' ') continue;
            return this.error(request, labels.getString("org.dspace.app.webui.servlet.admin.MetadataFieldRegistryServlet.badelemchar"));
        }
        if (element.length() > 64) {
            return this.error(request, labels.getString("org.dspace.app.webui.servlet.admin.MetadataFieldRegistryServlet.elemtoolong"));
        }
        String qualifier = request.getParameter("qualifier");
        if ("".equals(qualifier)) {
            qualifier = null;
        }
        if (qualifier != null) {
            if (qualifier.length() > 64) {
                return this.error(request, labels.getString("org.dspace.app.webui.servlet.admin.MetadataFieldRegistryServlet.qualtoolong"));
            }
            for (int ii = 0; ii < qualifier.length(); ++ii) {
                if (qualifier.charAt(ii) != '.' && qualifier.charAt(ii) != '_' && qualifier.charAt(ii) != ' ') continue;
                return this.error(request, labels.getString("org.dspace.app.webui.servlet.admin.MetadataFieldRegistryServlet.badqualchar"));
            }
        }
        return true;
    }

    private boolean error(HttpServletRequest request, String text) {
        request.setAttribute("error", (Object)text);
        return false;
    }
}

