/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class WorkspaceServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(WorkspaceServlet.class);
    private final transient WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();

    protected void doDSGet(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSPost(c, request, response);
    }

    protected void doDSPost(Context c, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_error");
        if (button.equals("submit_open")) {
            this.showMainPage(c, request, response);
        } else if (button.equals("submit_cancel")) {
            this.goToMyDSpace(c, request, response);
        } else if (button.equals("submit_error")) {
            this.showErrorPage(c, request, response);
        }
    }

    private void showErrorPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int wsItemID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"workspace_id");
        log.error((Object)LogManager.getHeader((Context)context, (String)"Workspace Item View Failed", (String)("workspace_item_id=" + wsItemID)));
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/workspace/ws-error.jsp");
    }

    private void goToMyDSpace(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + "/mydspace"));
    }

    private void showMainPage(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int wsItemID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"workspace_id");
        WorkspaceItem wsItem = this.workspaceItemService.find(context, wsItemID);
        Item item = wsItem.getItem();
        this.authorizeService.authorizeAction(context, (DSpaceObject)item, 0);
        log.info((Object)LogManager.getHeader((Context)context, (String)"View Workspace Item", (String)("workspace_item_id=" + wsItemID)));
        request.setAttribute("wsItem", (Object)wsItem);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/workspace/ws-main.jsp");
    }
}

