/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.itemimport.BTEBatchImportService;
import org.dspace.app.itemimport.factory.ItemImportServiceFactory;
import org.dspace.app.itemimport.service.ItemImportService;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.FileUploadRequest;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.utils.DSpace;

public class BatchImportServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(BatchImportServlet.class);
    private final transient CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private final transient ItemImportService itemImportService = ItemImportServiceFactory.getInstance().getItemImportService();

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            String message = null;
            try {
                String uploadId;
                FileUploadRequest wrapper = new FileUploadRequest(request);
                String inputType = wrapper.getParameter("inputType");
                List reqCollectionsTmp = this.getRepeatedParameter((HttpServletRequest)wrapper, "collections", "collections");
                String[] reqCollections = new String[reqCollectionsTmp.size()];
                reqCollectionsTmp.toArray(reqCollections);
                List<Object> collections = null;
                String colIdS = wrapper.getParameter("colId");
                if (colIdS != null) {
                    collections = new ArrayList<DSpaceObject>();
                    collections.add(this.collectionService.findByIdOrLegacyId(context, colIdS));
                } else {
                    collections = this.collectionService.findAll(context);
                }
                request.setAttribute("collections", collections);
                Collection owningCollection = null;
                if (wrapper.getParameter("collection") != null) {
                    owningCollection = (Collection)this.collectionService.findByIdOrLegacyId(context, wrapper.getParameter("collection"));
                }
                BTEBatchImportService dls = (BTEBatchImportService)new DSpace().getSingletonService(BTEBatchImportService.class);
                List inputTypes = dls.getFileDataLoaders();
                request.setAttribute("input-types", (Object)inputTypes);
                if (reqCollectionsTmp != null) {
                    request.setAttribute("otherCollections", (Object)reqCollectionsTmp);
                }
                if (owningCollection != null) {
                    request.setAttribute("owningCollection", (Object)owningCollection.getID());
                }
                request.setAttribute("inputType", (Object)inputType);
                File f = null;
                String zipurl = null;
                if (inputType.equals("saf")) {
                    zipurl = wrapper.getParameter("zipurl");
                    if (StringUtils.isEmpty((CharSequence)zipurl)) {
                        request.setAttribute("has-error", (Object)"true");
                        Locale locale = request.getLocale();
                        ResourceBundle msgs = ResourceBundle.getBundle("Messages", locale);
                        try {
                            message = msgs.getString("jsp.layout.navbar-admin.batchimport.fileurlempty");
                        }
                        catch (Exception e) {
                            message = "???jsp.layout.navbar-admin.batchimport.fileurlempty???";
                        }
                        request.setAttribute("message", (Object)message);
                        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/batchimport.jsp");
                        return;
                    }
                } else {
                    f = wrapper.getFile("file");
                    if (f == null) {
                        request.setAttribute("has-error", (Object)"true");
                        Locale locale = request.getLocale();
                        ResourceBundle msgs = ResourceBundle.getBundle("Messages", locale);
                        try {
                            message = msgs.getString("jsp.layout.navbar-admin.batchimport.fileempty");
                        }
                        catch (Exception e) {
                            message = "???jsp.layout.navbar-admin.batchimport.fileempty???";
                        }
                        request.setAttribute("message", (Object)message);
                        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/batchimport.jsp");
                        return;
                    }
                    if (owningCollection == null && !"safupload".equals(inputType)) {
                        request.setAttribute("has-error", (Object)"true");
                        Locale locale = request.getLocale();
                        ResourceBundle msgs = ResourceBundle.getBundle("Messages", locale);
                        try {
                            message = msgs.getString("jsp.layout.navbar-admin.batchimport.owningcollectionempty");
                        }
                        catch (Exception e) {
                            message = "???jsp.layout.navbar-admin.batchimport.owningcollectionempty???";
                        }
                        request.setAttribute("message", (Object)message);
                        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/batchimport.jsp");
                        return;
                    }
                }
                if ((uploadId = wrapper.getParameter("uploadId")) != null) {
                    request.setAttribute("uploadId", (Object)uploadId);
                }
                if (owningCollection == null && reqCollections != null && reqCollections.length > 0) {
                    request.setAttribute("has-error", (Object)"true");
                    Locale locale = request.getLocale();
                    ResourceBundle msgs = ResourceBundle.getBundle("Messages", locale);
                    String ms = msgs.getString("jsp.layout.navbar-admin.batchimport.owningcollection");
                    if (ms == null) {
                        ms = "???jsp.layout.navbar-admin.batchimport.owningcollection???";
                    }
                    request.setAttribute("message", (Object)ms);
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/batchimport.jsp");
                    return;
                }
                try {
                    String finalInputType = "saf";
                    String filePath = zipurl;
                    if (f != null) {
                        finalInputType = inputType;
                        filePath = f.getAbsolutePath();
                    }
                    this.itemImportService.processUIImport(filePath, owningCollection, reqCollections, uploadId, finalInputType, context, true);
                    request.setAttribute("has-error", (Object)"false");
                    request.setAttribute("uploadId", null);
                }
                catch (Exception e) {
                    request.setAttribute("has-error", (Object)"true");
                    message = e.getMessage();
                    e.printStackTrace();
                }
            }
            catch (FileUploadBase.FileSizeLimitExceededException e) {
                request.setAttribute("has-error", (Object)"true");
                message = e.getMessage();
                e.printStackTrace();
            }
            catch (Exception e) {
                request.setAttribute("has-error", (Object)"true");
                message = e.getMessage();
                e.printStackTrace();
            }
            request.setAttribute("message", (Object)message);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/batchimport.jsp");
        } else {
            request.setAttribute("has-error", (Object)"true");
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/batchimport.jsp");
        }
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        List<Object> collections = null;
        String colIdS = request.getParameter("colId");
        if (colIdS != null) {
            collections = new ArrayList<DSpaceObject>();
            collections.add(this.collectionService.findByIdOrLegacyId(context, colIdS));
        } else {
            collections = this.collectionService.findAll(context);
        }
        request.setAttribute("collections", collections);
        BTEBatchImportService dls = (BTEBatchImportService)new DSpace().getSingletonService(BTEBatchImportService.class);
        List inputTypes = dls.getFileDataLoaders();
        request.setAttribute("input-types", (Object)inputTypes);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/dspace-admin/batchimport.jsp");
    }

    protected List<String> getRepeatedParameter(HttpServletRequest request, String metadataField, String param) {
        LinkedList<String> vals = new LinkedList<String>();
        int i = 1;
        boolean foundLast = false;
        while (!foundLast) {
            String s = null;
            s = request.getParameter(param + "_" + i);
            if (s == null) {
                s = request.getParameter(param);
                foundLast = true;
            }
            if (s != null) {
                boolean addValue = true;
                String[] selected = request.getParameterValues(metadataField + "_selected");
                if (selected != null) {
                    for (int j = 0; j < selected.length; ++j) {
                        if (!selected[j].equals(metadataField + "_" + i)) continue;
                        addValue = false;
                    }
                }
                if (addValue) {
                    vals.add(s.trim());
                }
            }
            ++i;
        }
        log.debug((Object)("getRepeatedParameter: metadataField=" + metadataField + " param=" + metadataField + ", return count = " + vals.size()));
        return vals;
    }
}

