/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.CrossLinks;
import org.dspace.content.Bitstream;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Thumbnail;
import org.dspace.content.authority.factory.ContentAuthorityServiceFactory;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sort.SortOption;

/*
 * Exception performing whole class analysis ignored.
 */
public class BrowseListTag
extends TagSupport {
    private static final Logger log;
    private List<Item> items;
    private int highlightRow = -1;
    private String emphColumn;
    private static boolean showThumbs;
    private static int thumbItemListMaxWidth;
    private static int thumbItemListMaxHeight;
    private static boolean linkToBitstream;
    private boolean linkToEdit = false;
    private boolean disableCrossLinks = false;
    private static final String[] DEFAULT_LIST_FIELDS;
    private static final String[] DEFAULT_LIST_WIDTHS;
    private static String dateField;
    private static String titleField;
    private static String authorField;
    private int authorLimit = -1;
    private transient BrowseInfo browseInfo;
    private static final long serialVersionUID = 8091584920304256107L;
    private final transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final transient MetadataAuthorityService metadataAuthorityService = ContentAuthorityServiceFactory.getInstance().getMetadataAuthorityService();
    private final transient BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private final transient ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest hrq = (HttpServletRequest)this.pageContext.getRequest();
        Object[] browseFields = null;
        Object[] browseWidths = null;
        if (this.browseInfo != null) {
            SortOption so = this.browseInfo.getSortOption();
            BrowseIndex bix = this.browseInfo.getBrowseIndex();
            if (bix != null) {
                if (so != null && ArrayUtils.isEmpty((Object[])browseFields)) {
                    browseFields = this.configurationService.getArrayProperty("webui.itemlist.browse." + bix.getName() + ".sort." + so.getName() + ".columns");
                    browseWidths = this.configurationService.getArrayProperty("webui.itemlist.browse." + bix.getName() + ".sort." + so.getName() + ".widths");
                }
                if (so == null) {
                    so = bix.getSortOption();
                }
            }
            if (so != null && ArrayUtils.isEmpty((Object[])browseFields)) {
                browseFields = this.configurationService.getArrayProperty("webui.itemlist.sort." + so.getName() + ".columns");
                browseWidths = this.configurationService.getArrayProperty("webui.itemlist.sort." + so.getName() + ".widths");
            }
            if (bix != null && ArrayUtils.isEmpty((Object[])browseFields)) {
                browseFields = this.configurationService.getArrayProperty("webui.itemlist.browse." + bix.getName() + ".columns");
                browseWidths = this.configurationService.getArrayProperty("webui.itemlist.browse." + bix.getName() + ".widths");
            }
            if (so != null && ArrayUtils.isEmpty((Object[])browseFields)) {
                browseFields = this.configurationService.getArrayProperty("webui.itemlist." + so.getName() + ".columns");
                browseWidths = this.configurationService.getArrayProperty("webui.itemlist." + so.getName() + ".widths");
            }
            if (bix != null && ArrayUtils.isEmpty((Object[])browseFields)) {
                browseFields = this.configurationService.getArrayProperty("webui.itemlist." + bix.getName() + ".columns");
                browseWidths = this.configurationService.getArrayProperty("webui.itemlist." + bix.getName() + ".widths");
            }
        }
        if (ArrayUtils.isEmpty(browseFields)) {
            browseFields = this.configurationService.getArrayProperty("webui.itemlist.columns");
            browseWidths = this.configurationService.getArrayProperty("webui.itemlist.widths");
        }
        if (ArrayUtils.isNotEmpty(browseFields)) {
            int thumbnailIndex;
            if (!showThumbs && (thumbnailIndex = ArrayUtils.indexOf((Object[])browseFields, (Object)"thumbnail")) >= 0) {
                browseFields = (String[])ArrayUtils.remove((Object[])browseFields, (int)thumbnailIndex);
                if (ArrayUtils.isNotEmpty((Object[])browseWidths)) {
                    browseWidths = (String[])ArrayUtils.remove((Object[])browseWidths, (int)thumbnailIndex);
                }
            }
        } else {
            browseFields = DEFAULT_LIST_FIELDS;
            browseWidths = DEFAULT_LIST_WIDTHS;
        }
        boolean[] isDate = new boolean[browseFields.length];
        boolean[] emph = new boolean[browseFields.length];
        boolean[] isAuthor = new boolean[browseFields.length];
        boolean[] viewFull = new boolean[browseFields.length];
        String[] browseType = new String[browseFields.length];
        String[] cOddOrEven = new String[browseFields.length];
        try {
            CrossLinks cl = new CrossLinks();
            String tablewidth = this.configurationService.getProperty("webui.itemlist.tablewidth");
            if (ArrayUtils.isNotEmpty((Object[])browseWidths) && browseWidths.length == browseFields.length && !this.linkToEdit) {
                if (!StringUtils.isEmpty((String)tablewidth)) {
                    out.println("<table style=\"width: " + tablewidth + "; table-layout: fixed;\" align=\"center\" class=\"table\" summary=\"This table browses all dspace content\">");
                } else {
                    out.println("<table align=\"center\" class=\"table\" summary=\"This table browses all dspace content\">");
                }
                out.print("<colgroup>");
                for (int w = 0; w < browseWidths.length; ++w) {
                    out.print("<col width=\"");
                    if (((String)browseFields[w]).equals("thumbnail") && ((String)browseWidths[w]).equals("*")) {
                        out.print(thumbItemListMaxWidth);
                    } else {
                        out.print((String)(StringUtils.isEmpty((String)browseWidths[w]) ? "*" : browseWidths[w]));
                    }
                    out.print("\" />");
                }
                out.println("</colgroup>");
            } else if (!StringUtils.isEmpty((String)tablewidth)) {
                out.println("<table width=\"" + tablewidth + "\" align=\"center\" class=\"table\" summary=\"This table browses all dspace content\">");
            } else {
                out.println("<table align=\"center\" class=\"table\" summary=\"This table browses all dspace content\">");
            }
            out.println("<tr>");
            for (int colIdx = 0; colIdx < browseFields.length; ++colIdx) {
                String field = ((String)browseFields[colIdx]).toLowerCase().trim();
                String string = cOddOrEven[colIdx] = (colIdx + 1) % 2 == 0 ? "Odd" : "Even";
                if (field.indexOf("(date)") > 0) {
                    field = field.replaceAll("\\(date\\)", "");
                    isDate[colIdx] = true;
                }
                browseFields[colIdx] = field;
                if (field.equals(authorField)) {
                    isAuthor[colIdx] = true;
                }
                if (cl.hasLink(field)) {
                    browseType[colIdx] = cl.getLinkType(field);
                    viewFull[colIdx] = BrowseIndex.getBrowseIndex((String)browseType[colIdx]).isItemIndex();
                }
                if (field.equals(this.emphColumn)) {
                    emph[colIdx] = true;
                }
                String id = "t" + Integer.toString(colIdx + 1);
                String css = "oddRow" + cOddOrEven[colIdx] + "Col";
                String message = "itemlist." + field;
                String markClass = "";
                if (field.startsWith("mark_")) {
                    markClass = " " + field + "_th";
                }
                out.print("<th id=\"" + id + "\" class=\"" + css + markClass + "\">" + (emph[colIdx] ? "<strong>" : "") + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)message) + (emph[colIdx] ? "</strong>" : "") + "</th>");
            }
            if (this.linkToEdit) {
                String id = "t" + Integer.toString(cOddOrEven.length + 1);
                String css = "oddRow" + cOddOrEven[cOddOrEven.length - 2] + "Col";
                out.print("<th id=\"" + id + "\" class=\"" + css + "\">" + (emph[emph.length - 2] ? "<strong>" : "") + "&nbsp;" + (emph[emph.length - 2] ? "</strong>" : "") + "</th>");
            }
            out.print("</tr>");
            for (Item item : this.items) {
                out.print("<tr>");
                for (int colIdx = 0; colIdx < browseFields.length; ++colIdx) {
                    Object field = browseFields[colIdx];
                    StringTokenizer eq = new StringTokenizer((String)field, ".");
                    String[] tokens = new String[]{"", "", ""};
                    int k = 0;
                    while (eq.hasMoreTokens()) {
                        tokens[k] = eq.nextToken().toLowerCase().trim();
                        ++k;
                    }
                    String schema = tokens[0];
                    String element = tokens[1];
                    String qualifier = tokens[2];
                    List metadataArray = qualifier.equals("*") ? this.itemService.getMetadata((DSpaceObject)item, schema, element, "*", "*") : (qualifier.equals("") ? this.itemService.getMetadata((DSpaceObject)item, schema, element, null, "*") : this.itemService.getMetadata((DSpaceObject)item, schema, element, qualifier, "*"));
                    if (metadataArray == null) {
                        metadataArray = new ArrayList();
                    }
                    String metadata = "-";
                    if (((String)field).equals("thumbnail")) {
                        metadata = this.getThumbMarkup(hrq, item);
                    } else if (((String)field).startsWith("mark_")) {
                        metadata = UIUtil.getMarkingMarkup((HttpServletRequest)hrq, (DSpaceObject)item, (String)field);
                    } else if (metadataArray.size() > 0) {
                        if (isDate[colIdx]) {
                            DCDate dd = new DCDate(((MetadataValue)metadataArray.get(0)).getValue());
                            metadata = UIUtil.displayDate((DCDate)dd, (boolean)false, (boolean)false, (HttpServletRequest)hrq);
                        } else if (((String)field).equals(titleField) && item.isWithdrawn()) {
                            metadata = Utils.addEntities((String)((MetadataValue)metadataArray.get(0)).getValue());
                        } else if (((String)field).equals(titleField)) {
                            metadata = "<a href=\"" + hrq.getContextPath() + "/handle/" + item.getHandle() + "\">" + Utils.addEntities((String)((MetadataValue)metadataArray.get(0)).getValue()) + "</a>";
                        } else {
                            boolean truncated = false;
                            int loopLimit = metadataArray.size();
                            if (isAuthor[colIdx]) {
                                int fieldMax = this.authorLimit == -1 ? metadataArray.size() : this.authorLimit;
                                loopLimit = fieldMax > metadataArray.size() ? metadataArray.size() : fieldMax;
                                truncated = fieldMax < metadataArray.size();
                                log.debug((Object)("Limiting output of field " + (String)field + " to " + Integer.toString(loopLimit) + " from an original " + Integer.toString(metadataArray.size())));
                            }
                            StringBuffer sb = new StringBuffer();
                            for (int j = 0; j < loopLimit; ++j) {
                                String startLink = "";
                                String endLink = "";
                                if (!StringUtils.isEmpty((String)browseType[colIdx]) && !this.disableCrossLinks) {
                                    String value;
                                    String argument;
                                    if (((MetadataValue)metadataArray.get(j)).getAuthority() != null && ((MetadataValue)metadataArray.get(j)).getConfidence() >= this.metadataAuthorityService.getMinConfidence(((MetadataValue)metadataArray.get(j)).getMetadataField())) {
                                        argument = "authority";
                                        value = ((MetadataValue)metadataArray.get(j)).getAuthority();
                                    } else {
                                        argument = "value";
                                        value = ((MetadataValue)metadataArray.get(j)).getValue();
                                    }
                                    if (viewFull[colIdx]) {
                                        argument = "vfocus";
                                    }
                                    startLink = "<a href=\"" + hrq.getContextPath() + "/browse?type=" + browseType[colIdx] + "&amp;" + argument + "=" + URLEncoder.encode(value, "UTF-8");
                                    if (((MetadataValue)metadataArray.get(j)).getLanguage() != null) {
                                        startLink = startLink + "&amp;" + argument + "_lang=" + URLEncoder.encode(((MetadataValue)metadataArray.get(j)).getLanguage(), "UTF-8");
                                    }
                                    startLink = "authority".equals(argument) ? startLink + "\" class=\"authority " + browseType[colIdx] + "\">" : startLink + "\">";
                                    endLink = "</a>";
                                }
                                sb.append(startLink);
                                sb.append(Utils.addEntities((String)((MetadataValue)metadataArray.get(j)).getValue()));
                                sb.append(endLink);
                                if (j >= loopLimit - 1) continue;
                                sb.append("; ");
                            }
                            if (truncated) {
                                String etal = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"itemlist.et-al");
                                sb.append(", ").append(etal);
                            }
                            metadata = "<em>" + sb.toString() + "</em>";
                        }
                    } else if (((String)field).equals(titleField)) {
                        String undefined = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"itemlist.title.undefined");
                        metadata = item.isWithdrawn() ? "<span style=\"font-style:italic\">(" + undefined + ")</span>" : "<a href=\"" + hrq.getContextPath() + "/handle/" + item.getHandle() + "\">" + "<span style=\"font-style:italic\">(" + undefined + ")</span>" + "</a>";
                    }
                    String extras = "";
                    if (isDate[colIdx]) {
                        extras = "nowrap=\"nowrap\" align=\"right\"";
                    }
                    String markClass = "";
                    if (((String)field).startsWith("mark_")) {
                        markClass = " " + (String)field + "_tr";
                    }
                    String id = "t" + Integer.toString(colIdx + 1);
                    out.print("<td headers=\"" + id + "\" " + extras + ">" + (emph[colIdx] ? "<strong>" : "") + metadata + (emph[colIdx] ? "</strong>" : "") + "</td>");
                }
                if (this.linkToEdit) {
                    String id = "t" + Integer.toString(cOddOrEven.length + 1);
                    out.print("<td headers=\"" + id + "\" nowrap=\"nowrap\">" + "<form method=\"get\" action=\"" + hrq.getContextPath() + "/tools/edit-item\">" + "<input type=\"hidden\" name=\"handle\" value=\"" + item.getHandle() + "\" />" + "<input type=\"submit\" value=\"Edit Item\" /></form>" + "</td>");
                }
                out.println("</tr>");
            }
            out.println("</table>");
        }
        catch (IOException | AuthorizeException | BrowseException e) {
            throw new JspException(e);
        }
        return 0;
    }

    public BrowseInfo getBrowseInfo() {
        return this.browseInfo;
    }

    public void setBrowseInfo(BrowseInfo browseInfo) {
        this.browseInfo = browseInfo;
        this.setItems(browseInfo.getBrowseItemResults());
        this.authorLimit = browseInfo.getEtAl();
    }

    public boolean getLinkToEdit() {
        return this.linkToEdit;
    }

    public void setLinkToEdit(boolean edit) {
        this.linkToEdit = edit;
    }

    public boolean getDisableCrossLinks() {
        return this.disableCrossLinks;
    }

    public void setDisableCrossLinks(boolean links) {
        this.disableCrossLinks = links;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> itemsIn) {
        this.items = itemsIn;
    }

    public String getHighlightrow() {
        return String.valueOf(this.highlightRow);
    }

    public void setHighlightrow(String highlightRowIn) {
        if (highlightRowIn == null || highlightRowIn.equals("")) {
            this.highlightRow = -1;
        } else {
            try {
                this.highlightRow = Integer.parseInt(highlightRowIn);
            }
            catch (NumberFormatException nfe) {
                this.highlightRow = -1;
            }
        }
    }

    public String getEmphcolumn() {
        return this.emphColumn;
    }

    public void setEmphcolumn(String emphColumnIn) {
        this.emphColumn = emphColumnIn;
    }

    public void release() {
        this.highlightRow = -1;
        this.emphColumn = null;
        this.items = null;
    }

    private static void getThumbSettings() {
        String linkBehaviour;
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        showThumbs = configurationService.getBooleanProperty("webui.browse.thumbnail.show");
        if (showThumbs) {
            thumbItemListMaxHeight = configurationService.getIntProperty("webui.browse.thumbnail.maxheight");
            if (thumbItemListMaxHeight == 0) {
                thumbItemListMaxHeight = configurationService.getIntProperty("thumbnail.maxheight");
            }
            if ((thumbItemListMaxWidth = configurationService.getIntProperty("webui.browse.thumbnail.maxwidth")) == 0) {
                thumbItemListMaxWidth = configurationService.getIntProperty("thumbnail.maxwidth");
            }
        }
        if ((linkBehaviour = configurationService.getProperty("webui.browse.thumbnail.linkbehaviour")) != null && linkBehaviour.equals("bitstream")) {
            linkToBitstream = true;
        }
    }

    private String getScalingAttr(HttpServletRequest hrq, Bitstream bitstream) throws JspException, AuthorizeException {
        float scaleFactor;
        BufferedImage buf;
        try {
            Context c = UIUtil.obtainContext((HttpServletRequest)hrq);
            InputStream is = this.bitstreamService.retrieve(c, bitstream);
            buf = ImageIO.read(is);
            is.close();
        }
        catch (SQLException sqle) {
            throw new JspException(sqle.getMessage(), (Throwable)sqle);
        }
        catch (IOException ioe) {
            throw new JspException(ioe.getMessage(), (Throwable)ioe);
        }
        float xsize = buf.getWidth(null);
        float ysize = buf.getHeight(null);
        if (xsize > (float)thumbItemListMaxWidth) {
            scaleFactor = (float)thumbItemListMaxWidth / xsize;
            xsize *= scaleFactor;
            ysize *= scaleFactor;
        }
        if (ysize > (float)thumbItemListMaxHeight) {
            scaleFactor = (float)thumbItemListMaxHeight / ysize;
            xsize *= scaleFactor;
            ysize *= scaleFactor;
        }
        StringBuffer sb = new StringBuffer("width=\"").append(xsize).append("\" height=\"").append(ysize).append("\"");
        return sb.toString();
    }

    private String getThumbMarkup(HttpServletRequest hrq, Item item) throws JspException, AuthorizeException {
        try {
            Context c = UIUtil.obtainContext((HttpServletRequest)hrq);
            Thumbnail thumbnail = this.itemService.getThumbnail(c, item, linkToBitstream);
            if (thumbnail == null) {
                return "";
            }
            StringBuffer thumbFrag = new StringBuffer();
            if (linkToBitstream) {
                Bitstream original = thumbnail.getOriginal();
                String link = hrq.getContextPath() + "/bitstream/" + item.getHandle() + "/" + original.getSequenceID() + "/" + UIUtil.encodeBitstreamName((String)original.getName(), (String)"UTF-8");
                thumbFrag.append("<a target=\"_blank\" href=\"").append(link).append("\" />");
            } else {
                String link = hrq.getContextPath() + "/handle/" + item.getHandle();
                thumbFrag.append("<a href=\"").append(link).append("\" />");
            }
            Bitstream thumb = thumbnail.getThumb();
            String img = hrq.getContextPath() + "/retrieve/" + thumb.getID() + "/" + UIUtil.encodeBitstreamName((String)thumb.getName(), (String)"UTF-8");
            String alt = thumb.getName();
            String scAttr = this.getScalingAttr(hrq, thumb);
            thumbFrag.append("<img src=\"").append(img).append("\" alt=\"").append(alt).append("\" ").append(scAttr).append("/ border=\"0\"></a>");
            return thumbFrag.toString();
        }
        catch (SQLException sqle) {
            throw new JspException(sqle.getMessage(), (Throwable)sqle);
        }
        catch (UnsupportedEncodingException e) {
            throw new JspException("Server does not support DSpace's default encoding. ", (Throwable)e);
        }
    }

    static {
        String authorLine;
        String titleLine;
        log = Logger.getLogger(BrowseListTag.class);
        linkToBitstream = false;
        dateField = "dc.date.issued";
        titleField = "dc.title";
        authorField = "dc.contributor.*";
        BrowseListTag.getThumbSettings();
        if (showThumbs) {
            DEFAULT_LIST_FIELDS = new String[]{"thumbnail", "dc.date.issued(date)", "dc.title", "dc.contributor.*"};
            DEFAULT_LIST_WIDTHS = new String[]{"*", "130", "60%", "40%"};
        } else {
            DEFAULT_LIST_FIELDS = new String[]{"dc.date.issued(date)", "dc.title", "dc.contributor.*"};
            DEFAULT_LIST_WIDTHS = new String[]{"130", "60%", "40%"};
        }
        String dateLine = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("webui.browse.index.date");
        if (dateLine != null) {
            dateField = dateLine;
        }
        if ((titleLine = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("webui.browse.index.title")) != null) {
            titleField = titleLine;
        }
        if ((authorLine = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("webui.browse.author-field")) != null) {
            authorField = authorLine;
        }
    }
}

