/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.json.JSONRequest;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.PluginManager;

public class JSONServlet
extends DSpaceServlet {
    private static Logger log = Logger.getLogger(JSONServlet.class);

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSGet(context, request, response);
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthorizeException {
        JSONRequest jsonReq;
        String pluginName = request.getPathInfo();
        if (pluginName == null) {
            pluginName = "";
        }
        if (pluginName.startsWith("/")) {
            pluginName = pluginName.substring(1);
            pluginName = pluginName.split("/")[0];
        }
        if ((jsonReq = (JSONRequest)PluginManager.getNamedPlugin(JSONRequest.class, (String)pluginName)) == null) {
            log.error((Object)LogManager.getHeader((Context)context, (String)"jsonrequest", (String)("No plugin found for manage the path " + pluginName)));
            response.sendError(404);
            return;
        }
        jsonReq.setSubPath(pluginName);
        try {
            response.setContentType("application/json; charset=UTF-8");
            jsonReq.doJSONRequest(context, request, response);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

