/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.MetadataExposure;
import org.dspace.app.util.Util;
import org.dspace.app.webui.util.StyleSelection;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.browse.BrowseException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.content.authority.MetadataAuthorityManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.PluginManager;
import org.dspace.core.Utils;

public class ItemTag
extends TagSupport {
    private static final String HANDLE_DEFAULT_BASEURL = "http://hdl.handle.net/";
    private static final String DOI_DEFAULT_BASEURL = "http://dx.doi.org/";
    private transient Item item;
    private transient Collection[] collections;
    private String style;
    private boolean showThumbs;
    private static String defaultFields;
    private static Logger log;
    private StyleSelection styleSelection = (StyleSelection)PluginManager.getSinglePlugin(StyleSelection.class);
    private static Map<String, String> linkedMetadata;
    private static Map<String, String> urn2baseurl;
    private Pattern fieldStylePatter = Pattern.compile(".*\\((.*)\\)");
    private static final long serialVersionUID = -3841266490729417240L;

    public ItemTag() {
        this.getThumbSettings();
    }

    public int doStartTag() throws JspException {
        try {
            if (this.style == null || this.style.equals("")) {
                this.style = this.styleSelection.getStyleForItem(this.item);
            }
            if (this.style.equals("full")) {
                this.renderFull();
            } else {
                this.render();
            }
        }
        catch (SQLException sqle) {
            throw new JspException((Throwable)sqle);
        }
        catch (IOException ie) {
            throw new JspException((Throwable)ie);
        }
        catch (DCInputsReaderException ex) {
            throw new JspException((Throwable)ex);
        }
        return 0;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item itemIn) {
        this.item = itemIn;
    }

    public Collection[] getCollections() {
        return (Collection[])ArrayUtils.clone((Object[])this.collections);
    }

    public void setCollections(Collection[] collectionsIn) {
        this.collections = (Collection[])ArrayUtils.clone((Object[])collectionsIn);
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String styleIn) {
        this.style = styleIn;
    }

    public void release() {
        this.style = "default";
        this.item = null;
        this.collections = null;
    }

    private void render() throws IOException, SQLException, DCInputsReaderException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Context context = UIUtil.obtainContext((HttpServletRequest)request);
        Locale sessionLocale = UIUtil.getSessionLocale((HttpServletRequest)request);
        String configLine = this.styleSelection.getConfigurationForStyle(this.style);
        if (configLine == null) {
            configLine = defaultFields;
        }
        out.println("<table class=\"table itemDisplayTable\">");
        StringTokenizer st = new StringTokenizer(configLine, ",");
        while (st.hasMoreTokens()) {
            Metadatum[] values;
            String browseIndex;
            String field = st.nextToken().trim();
            boolean isDate = false;
            boolean isLink = false;
            boolean isResolver = false;
            boolean isNoBreakLine = false;
            boolean isDisplay = false;
            String style = null;
            Matcher fieldStyleMatcher = this.fieldStylePatter.matcher(field);
            if (fieldStyleMatcher.matches()) {
                style = fieldStyleMatcher.group(1);
            }
            try {
                browseIndex = this.getBrowseField(field);
            }
            catch (BrowseException e) {
                log.error((Object)e);
                browseIndex = null;
            }
            if (style != null) {
                isDate = style.contains("date");
                isLink = style.contains("link");
                isNoBreakLine = style.contains("nobreakline");
                isDisplay = style.equals("inputform");
                isResolver = style.contains("resolver") || urn2baseurl.keySet().contains(style);
                field = field.replaceAll("\\(" + style + "\\)", "");
            }
            String[] eq = field.split("\\.");
            String schema = eq[0];
            String element = eq[1];
            String qualifier = null;
            if (eq.length > 2 && eq[2].equals("*")) {
                qualifier = "*";
            } else if (eq.length > 2) {
                qualifier = eq[2];
            }
            if (MetadataExposure.isHidden((Context)context, (String)schema, (String)element, (String)qualifier) || (values = this.item.getMetadata(schema, element, qualifier, "*")).length <= 0) continue;
            out.print("<tr><td class=\"metadataFieldLabel\">");
            String label = null;
            try {
                label = I18nUtil.getMessage((String)("metadata." + ("default".equals(this.style) ? "" : this.style + ".") + field), (Context)context);
            }
            catch (MissingResourceException e) {
                label = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)("metadata." + field));
            }
            out.print(label);
            out.print(":&nbsp;</td><td class=\"metadataFieldValue\">");
            if (isDisplay) {
                List displayValues = new ArrayList();
                displayValues = Util.getControlledVocabulariesDisplayValueLocalized((Item)this.item, (Metadatum[])values, (String)schema, (String)element, (String)qualifier, (Locale)sessionLocale);
                if (displayValues != null && !displayValues.isEmpty()) {
                    for (int d = 0; d < displayValues.size(); ++d) {
                        out.print((String)displayValues.get(d));
                        if (d >= displayValues.size() - 1) continue;
                        out.print(" <br/>");
                    }
                }
                out.print("</td>");
                continue;
            }
            for (int j = 0; j < values.length; ++j) {
                if (values[j] == null || values[j].value == null) continue;
                if (j > 0) {
                    if (isNoBreakLine) {
                        String separator = ConfigurationManager.getProperty((String)"webui.itemdisplay.nobreakline.separator");
                        if (separator == null) {
                            separator = ";&nbsp;";
                        }
                        out.print(separator);
                    } else {
                        out.print("<br />");
                    }
                }
                if (isLink) {
                    out.print("<a href=\"" + values[j].value + "\">" + Utils.addEntities((String)values[j].value) + "</a>");
                    continue;
                }
                if (isDate) {
                    DCDate dd = new DCDate(values[j].value);
                    out.print(UIUtil.displayDate((DCDate)dd, (boolean)false, (boolean)false, (HttpServletRequest)((HttpServletRequest)this.pageContext.getRequest())));
                    continue;
                }
                if (isResolver) {
                    String value = values[j].value;
                    if (value.startsWith("http://") || value.startsWith("https://") || value.startsWith("ftp://") || value.startsWith("ftps://")) {
                        out.print("<a href=\"" + value + "\">" + Utils.addEntities((String)value) + "</a>");
                        continue;
                    }
                    String foundUrn = null;
                    if (!style.equals("resolver")) {
                        foundUrn = style;
                    } else {
                        for (String checkUrn : urn2baseurl.keySet()) {
                            if (!value.startsWith(checkUrn)) continue;
                            foundUrn = checkUrn;
                        }
                    }
                    if (foundUrn != null) {
                        if (value.startsWith(foundUrn + ":")) {
                            value = value.substring(foundUrn.length() + 1);
                        }
                        String url = (String)urn2baseurl.get(foundUrn);
                        out.print("<a href=\"" + url + value + "\">" + Utils.addEntities((String)values[j].value) + "</a>");
                        continue;
                    }
                    out.print(value);
                    continue;
                }
                if (browseIndex != null) {
                    String value;
                    String argument;
                    if (values[j].authority != null && values[j].confidence >= MetadataAuthorityManager.getManager().getMinConfidence(values[j].schema, values[j].element, values[j].qualifier)) {
                        argument = "authority";
                        value = values[j].authority;
                    } else {
                        argument = "value";
                        value = values[j].value;
                    }
                    out.print("<a class=\"" + ("authority".equals(argument) ? "authority " : "") + browseIndex + "\"" + "href=\"" + request.getContextPath() + "/browse?type=" + browseIndex + "&amp;" + argument + "=" + URLEncoder.encode(value, "UTF-8") + "\">" + Utils.addEntities((String)values[j].value) + "</a>");
                    continue;
                }
                out.print(Utils.addEntities((String)values[j].value));
            }
            out.println("</td></tr>");
        }
        this.listCollections();
        out.println("</table><br/>");
        this.listBitstreams();
        if (ConfigurationManager.getBooleanProperty((String)"webui.licence_bundle.show")) {
            out.println("<br/><br/>");
            this.showLicence();
        }
    }

    private void renderFull() throws IOException, SQLException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Context context = UIUtil.obtainContext((HttpServletRequest)request);
        Metadatum[] values = this.item.getMetadata("*", "*", "*", "*");
        out.println("<div class=\"panel panel-info\"><div class=\"panel-heading\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.full") + "</div>");
        out.println("<table class=\"panel-body table itemDisplayTable\">");
        out.println("<tr><th id=\"s1\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.dcfield") + "</th><th id=\"s2\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.value") + "</th><th id=\"s3\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.lang") + "</th></tr>");
        for (int i = 0; i < values.length; ++i) {
            if (MetadataExposure.isHidden((Context)context, (String)values[i].schema, (String)values[i].element, (String)values[i].qualifier)) continue;
            out.print("<tr><td headers=\"s1\" class=\"metadataFieldLabel\">");
            out.print(values[i].schema);
            out.print("." + values[i].element);
            if (values[i].qualifier != null) {
                out.print("." + values[i].qualifier);
            }
            out.print("</td><td headers=\"s2\" class=\"metadataFieldValue\">");
            out.print(Utils.addEntities((String)values[i].value));
            out.print("</td><td headers=\"s3\" class=\"metadataFieldValue\">");
            if (values[i].language == null) {
                out.print("-");
            } else {
                out.print(values[i].language);
            }
            out.println("</td></tr>");
        }
        this.listCollections();
        out.println("</table></div><br/>");
        this.listBitstreams();
        if (ConfigurationManager.getBooleanProperty((String)"webui.licence_bundle.show")) {
            out.println("<br/><br/>");
            this.showLicence();
        }
    }

    private void listCollections() throws IOException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (this.collections != null) {
            out.print("<tr><td class=\"metadataFieldLabel\">");
            if (this.item.getHandle() == null) {
                out.print(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.submitted"));
            } else {
                out.print(LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.appears"));
            }
            out.print("</td><td class=\"metadataFieldValue\"" + (this.style.equals("full") ? "colspan=\"2\"" : "") + ">");
            for (int i = 0; i < this.collections.length; ++i) {
                out.print("<a href=\"");
                out.print(request.getContextPath());
                out.print("/handle/");
                out.print(this.collections[i].getHandle());
                out.print("\">");
                out.print(this.collections[i].getMetadata("name"));
                out.print("</a><br/>");
            }
            out.println("</td></tr>");
        }
    }

    private void listBitstreams() throws IOException {
        JspWriter out;
        block21: {
            out = this.pageContext.getOut();
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            out.print("<div class=\"panel panel-info\">");
            out.println("<div class=\"panel-heading\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.files") + "</div>");
            try {
                Bundle[] bundles = this.item.getBundles("ORIGINAL");
                boolean filesExist = false;
                for (Bundle bnd : bundles) {
                    boolean bl = filesExist = bnd.getBitstreams().length > 0;
                    if (filesExist) break;
                }
                if (!filesExist) {
                    out.println("<div class=\"panel-body\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.files.no") + "</div>");
                    break block21;
                }
                boolean html = false;
                String handle = this.item.getHandle();
                Bitstream primaryBitstream = null;
                Bundle[] bunds = this.item.getBundles("ORIGINAL");
                Bundle[] thumbs = this.item.getBundles("THUMBNAIL");
                boolean multiFile = false;
                Bundle[] allBundles = this.item.getBundles();
                int filecount = 0;
                for (int i = 0; i < allBundles.length && !multiFile; ++i) {
                    multiFile = (filecount += allBundles[i].getBitstreams().length) > 1;
                }
                if (bunds[0] != null) {
                    Bitstream[] bits = bunds[0].getBitstreams();
                    for (int i = 0; i < bits.length && !html; ++i) {
                        if (bits[i].getID() != bunds[0].getPrimaryBitstreamID()) continue;
                        html = bits[i].getFormat().getMIMEType().equals("text/html");
                        primaryBitstream = bits[i];
                    }
                }
                out.println("<table class=\"table panel-body\"><tr><th id=\"t1\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.file") + "</th>");
                if (multiFile) {
                    out.println("<th id=\"t2\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.description") + "</th>");
                }
                out.println("<th id=\"t3\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.filesize") + "</th><th id=\"t4\" class=\"standard\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.fileformat") + "</th><th>&nbsp;</th></tr>");
                if (html) {
                    if (handle == null) {
                        handle = "db-id/" + this.item.getID();
                    }
                    out.print("<tr><td headers=\"t1\" class=\"standard\">");
                    out.print("<a target=\"_blank\" href=\"");
                    out.print(request.getContextPath());
                    out.print("/html/");
                    out.print(handle + "/");
                    out.print(UIUtil.encodeBitstreamName((String)primaryBitstream.getName(), (String)"UTF-8"));
                    out.print("\">");
                    out.print(primaryBitstream.getName());
                    out.print("</a>");
                    if (multiFile) {
                        out.print("</td><td headers=\"t2\" class=\"standard\">");
                        String desc = primaryBitstream.getDescription();
                        out.print(desc != null ? desc : "");
                    }
                    out.print("</td><td headers=\"t3\" class=\"standard\">");
                    out.print(UIUtil.formatFileSize((double)primaryBitstream.getSize()));
                    out.print("</td><td headers=\"t4\" class=\"standard\">");
                    out.print(primaryBitstream.getFormatDescription());
                    out.print("</td><td class=\"standard\"><a class=\"btn btn-primary\" target=\"_blank\" href=\"");
                    out.print(request.getContextPath());
                    out.print("/html/");
                    out.print(handle + "/");
                    out.print(UIUtil.encodeBitstreamName((String)primaryBitstream.getName(), (String)"UTF-8"));
                    out.print("\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.view") + "</a></td></tr>");
                } else {
                    Context context = UIUtil.obtainContext((HttpServletRequest)request);
                    boolean showRequestCopy = false;
                    if ("all".equalsIgnoreCase(ConfigurationManager.getProperty((String)"request.item.type")) || "logged".equalsIgnoreCase(ConfigurationManager.getProperty((String)"request.item.type")) && context.getCurrentUser() != null) {
                        showRequestCopy = true;
                    }
                    for (int i = 0; i < bundles.length; ++i) {
                        Bitstream[] bitstreams = bundles[i].getBitstreams();
                        for (int k = 0; k < bitstreams.length; ++k) {
                            if (bitstreams[k].getFormat().isInternal()) continue;
                            String bsLink = "target=\"_blank\" href=\"" + request.getContextPath();
                            bsLink = handle != null && bitstreams[k].getSequenceID() > 0 ? bsLink + "/bitstream/" + this.item.getHandle() + "/" + bitstreams[k].getSequenceID() + "/" : bsLink + "/retrieve/" + bitstreams[k].getID() + "/";
                            bsLink = bsLink + UIUtil.encodeBitstreamName((String)bitstreams[k].getName(), (String)"UTF-8") + "\">";
                            out.print("<tr><td headers=\"t1\" class=\"standard\">");
                            out.print("<a ");
                            out.print(bsLink);
                            out.print(bitstreams[k].getName());
                            out.print("</a>");
                            if (multiFile) {
                                out.print("</td><td headers=\"t2\" class=\"standard\">");
                                String desc = bitstreams[k].getDescription();
                                out.print(desc != null ? desc : "");
                            }
                            out.print("</td><td headers=\"t3\" class=\"standard\">");
                            out.print(UIUtil.formatFileSize((double)bitstreams[k].getSize()));
                            out.print("</td><td headers=\"t4\" class=\"standard\">");
                            out.print(bitstreams[k].getFormatDescription());
                            out.print("</td><td class=\"standard\" align=\"center\">");
                            if (thumbs.length > 0 && this.showThumbs) {
                                String tName = bitstreams[k].getName() + ".jpg";
                                String tAltText = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.thumbnail");
                                Bitstream tb = thumbs[0].getBitstreamByName(tName);
                                if (tb != null && AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)tb, (int)0)) {
                                    String myPath = request.getContextPath() + "/retrieve/" + tb.getID() + "/" + UIUtil.encodeBitstreamName((String)tb.getName(), (String)"UTF-8");
                                    out.print("<a ");
                                    out.print(bsLink);
                                    out.print("<img src=\"" + myPath + "\" ");
                                    out.print("alt=\"" + tAltText + "\" /></a><br />");
                                }
                            }
                            out.print("<a class=\"btn btn-primary\" ");
                            out.print(bsLink + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.view") + "</a>");
                            try {
                                if (showRequestCopy && !AuthorizeManager.authorizeActionBoolean((Context)context, (DSpaceObject)bitstreams[k], (int)0)) {
                                    out.print("&nbsp;<a class=\"btn btn-success\" href=\"" + request.getContextPath() + "/request-item?handle=" + handle + "&bitstream-id=" + bitstreams[k].getID() + "\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.restrict") + "</a>");
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            out.print("</td></tr>");
                        }
                    }
                }
                out.println("</table>");
            }
            catch (SQLException sqle) {
                throw new IOException(sqle.getMessage(), sqle);
            }
        }
        out.println("</div>");
    }

    private void getThumbSettings() {
        this.showThumbs = ConfigurationManager.getBooleanProperty((String)"webui.item.thumbnail.show");
    }

    private void showLicence() throws IOException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Bundle[] bundles = null;
        try {
            bundles = this.item.getBundles("LICENSE");
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage(), sqle);
        }
        out.println("<table align=\"center\" class=\"table attentionTable\"><tr>");
        out.println("<td class=\"attentionCell\"><p><strong>" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.itemprotected") + "</strong></p>");
        for (int i = 0; i < bundles.length; ++i) {
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            for (int k = 0; k < bitstreams.length; ++k) {
                out.print("<div align=\"center\" class=\"standard\">");
                out.print("<strong><a class=\"btn btn-primary\" target=\"_blank\" href=\"");
                out.print(request.getContextPath());
                out.print("/retrieve/");
                out.print(bitstreams[k].getID() + "/");
                out.print(UIUtil.encodeBitstreamName((String)bitstreams[k].getName(), (String)"UTF-8"));
                out.print("\">" + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.ItemTag.viewlicence") + "</a></strong></div>");
            }
        }
        out.println("</td></tr></table>");
    }

    private String getBrowseField(String field) throws BrowseException {
        for (String indexName : linkedMetadata.keySet()) {
            StringTokenizer bw_dcf = new StringTokenizer((String)linkedMetadata.get(indexName), ".");
            String[] bw_tokens = new String[]{"", "", ""};
            int i = 0;
            while (bw_dcf.hasMoreTokens()) {
                bw_tokens[i] = bw_dcf.nextToken().toLowerCase().trim();
                ++i;
            }
            String bw_schema = bw_tokens[0];
            String bw_element = bw_tokens[1];
            String bw_qualifier = bw_tokens[2];
            StringTokenizer dcf = new StringTokenizer(field, ".");
            String[] tokens = new String[]{"", "", ""};
            int j = 0;
            while (dcf.hasMoreTokens()) {
                tokens[j] = dcf.nextToken().toLowerCase().trim();
                ++j;
            }
            String schema = tokens[0];
            String element = tokens[1];
            String qualifier = tokens[2];
            if (!schema.equals(bw_schema) || !element.equals(bw_element) || (bw_qualifier == null || (qualifier == null || !qualifier.equals(bw_qualifier)) && !bw_qualifier.equals("*")) && (bw_qualifier != null || qualifier != null)) continue;
            return indexName;
        }
        return null;
    }

    static {
        String urn;
        String linkMetadata;
        defaultFields = "dc.title, dc.title.alternative, dc.contributor.*, dc.subject, dc.date.issued(date), dc.publisher, dc.identifier.citation, dc.relation.ispartofseries, dc.description.abstract, dc.description, dc.identifier.govdoc, dc.identifier.uri(link), dc.identifier.isbn, dc.identifier.issn, dc.identifier.ismn, dc.identifier";
        log = Logger.getLogger(ItemTag.class);
        linkedMetadata = new HashMap();
        int i = 1;
        do {
            if ((linkMetadata = ConfigurationManager.getProperty((String)("webui.browse.link." + i))) != null) {
                String[] linkedMetadataSplit = linkMetadata.split(":");
                String indexName = linkedMetadataSplit[0].trim();
                String metadataName = linkedMetadataSplit[1].trim();
                linkedMetadata.put(indexName, metadataName);
            }
            ++i;
        } while (linkMetadata != null);
        urn2baseurl = new HashMap();
        i = 1;
        do {
            if ((urn = ConfigurationManager.getProperty((String)("webui.resolver." + i + ".urn"))) != null) {
                String baseurl = ConfigurationManager.getProperty((String)("webui.resolver." + i + ".baseurl"));
                if (baseurl != null) {
                    urn2baseurl.put(urn, baseurl);
                } else {
                    log.warn((Object)("Wrong webui.resolver configuration, you need to specify both webui.resolver.<n>.urn and webui.resolver.<n>.baseurl: missing baseurl for n = " + i));
                }
            }
            ++i;
        } while (urn != null);
        if (!urn2baseurl.containsKey("doi")) {
            urn2baseurl.put("doi", DOI_DEFAULT_BASEURL);
        }
        if (!urn2baseurl.containsKey("hdl")) {
            urn2baseurl.put("hdl", HANDLE_DEFAULT_BASEURL);
        }
    }
}

