/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.CrossLinks;
import org.dspace.content.Bitstream;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.content.Thumbnail;
import org.dspace.content.authority.MetadataAuthorityManager;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.sort.SortOption;
import org.dspace.storage.bitstore.BitstreamStorageManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItemListTag
extends TagSupport {
    private static Logger log;
    private transient Item[] items;
    private int highlightRow = -1;
    private String emphColumn;
    private static boolean showThumbs;
    private static int thumbItemListMaxWidth;
    private static int thumbItemListMaxHeight;
    private static boolean linkToBitstream;
    private boolean linkToEdit = false;
    private boolean disableCrossLinks = false;
    private static final String DEFAULT_LIST_FIELDS;
    private static final String DEFAULT_LIST_WIDTHS;
    private static String dateField;
    private static String titleField;
    private static String authorField;
    private int authorLimit = -1;
    private transient SortOption sortOption = null;
    private static final long serialVersionUID = 348762897199116432L;

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest hrq = (HttpServletRequest)this.pageContext.getRequest();
        boolean emphasiseDate = false;
        boolean emphasiseTitle = false;
        if (this.emphColumn != null) {
            emphasiseDate = this.emphColumn.equalsIgnoreCase("date");
            emphasiseTitle = this.emphColumn.equalsIgnoreCase("title");
        }
        String configLine = null;
        String widthLine = null;
        if (this.sortOption != null) {
            if (configLine == null) {
                configLine = ConfigurationManager.getProperty((String)("webui.itemlist.sort." + this.sortOption.getName() + ".columns"));
                widthLine = ConfigurationManager.getProperty((String)("webui.itemlist.sort." + this.sortOption.getName() + ".widths"));
            }
            if (configLine == null) {
                configLine = ConfigurationManager.getProperty((String)("webui.itemlist." + this.sortOption.getName() + ".columns"));
                widthLine = ConfigurationManager.getProperty((String)("webui.itemlist." + this.sortOption.getName() + ".widths"));
            }
        }
        if (configLine == null) {
            configLine = ConfigurationManager.getProperty((String)"webui.itemlist.columns");
            widthLine = ConfigurationManager.getProperty((String)"webui.itemlist.widths");
        }
        if (configLine != null) {
            if (!showThumbs && configLine.contains("thumbnail")) {
                configLine = configLine == null ? "" : configLine;
                widthLine = widthLine == null ? "" : widthLine;
                StringTokenizer llt = new StringTokenizer(configLine, ",");
                StringTokenizer wlt = new StringTokenizer(widthLine, ",");
                StringBuilder newLLine = new StringBuilder();
                StringBuilder newWLine = new StringBuilder();
                while (llt.hasMoreTokens() || wlt.hasMoreTokens()) {
                    String widthTok;
                    String listTok = llt.hasMoreTokens() ? llt.nextToken() : null;
                    String string = widthTok = wlt.hasMoreTokens() ? wlt.nextToken() : null;
                    if (listTok != null && listTok.trim().equals("thumbnail")) continue;
                    if (listTok != null) {
                        if (newLLine.length() > 0) {
                            newLLine.append(",");
                        }
                        newLLine.append(listTok);
                    }
                    if (widthTok == null) continue;
                    if (newWLine.length() > 0) {
                        newWLine.append(",");
                    }
                    newWLine.append(widthTok);
                }
                configLine = newLLine.toString();
                widthLine = newWLine.toString();
            }
        } else {
            configLine = DEFAULT_LIST_FIELDS;
            widthLine = DEFAULT_LIST_WIDTHS;
        }
        String[] fieldArr = configLine == null ? new String[]{} : configLine.split("\\s*,\\s*");
        String[] widthArr = widthLine == null ? new String[]{} : widthLine.split("\\s*,\\s*");
        boolean[] isDate = new boolean[fieldArr.length];
        boolean[] emph = new boolean[fieldArr.length];
        boolean[] isAuthor = new boolean[fieldArr.length];
        boolean[] viewFull = new boolean[fieldArr.length];
        String[] browseType = new String[fieldArr.length];
        String[] cOddOrEven = new String[fieldArr.length];
        try {
            CrossLinks cl = new CrossLinks();
            String tablewidth = ConfigurationManager.getProperty((String)"webui.itemlist.tablewidth");
            if (widthArr.length > 0 && widthArr.length == fieldArr.length && !this.linkToEdit) {
                if (!StringUtils.isEmpty((String)tablewidth)) {
                    out.println("<table style=\"width: " + tablewidth + "; table-layout: fixed;\" align=\"center\" class=\"table\" summary=\"This table browses all dspace content\">");
                } else {
                    out.println("<table align=\"center\" class=\"table\" summary=\"This table browses all dspace content\">");
                }
                out.print("<colgroup>");
                for (int w = 0; w < widthArr.length; ++w) {
                    out.print("<col width=\"");
                    if (fieldArr[w].equals("thumbnail") && widthArr[w].equals("*")) {
                        out.print(thumbItemListMaxWidth);
                    } else {
                        out.print(StringUtils.isEmpty((String)widthArr[w]) ? "*" : widthArr[w]);
                    }
                    out.print("\" />");
                }
                out.println("</colgroup>");
            } else if (!StringUtils.isEmpty((String)tablewidth)) {
                out.println("<table width=\"" + tablewidth + "\" align=\"center\" class=\"table\" summary=\"This table browses all dspace content\">");
            } else {
                out.println("<table align=\"center\" class=\"table\" summary=\"This table browses all dspace content\">");
            }
            out.println("<tr>");
            for (int colIdx = 0; colIdx < fieldArr.length; ++colIdx) {
                String field = fieldArr[colIdx].toLowerCase().trim();
                String string = cOddOrEven[colIdx] = (colIdx + 1) % 2 == 0 ? "Odd" : "Even";
                if (field.indexOf("(date)") > 0) {
                    field = field.replaceAll("\\(date\\)", "");
                    isDate[colIdx] = true;
                }
                fieldArr[colIdx] = field;
                if (field.equals(authorField)) {
                    isAuthor[colIdx] = true;
                }
                if (cl.hasLink(field)) {
                    browseType[colIdx] = cl.getLinkType(field);
                    viewFull[colIdx] = BrowseIndex.getBrowseIndex((String)browseType[colIdx]).isItemIndex();
                }
                if (field.equals(this.emphColumn)) {
                    emph[colIdx] = true;
                } else if (field.equals(dateField) && emphasiseDate || field.equals(titleField) && emphasiseTitle) {
                    emph[colIdx] = true;
                }
                String id = "t" + Integer.toString(colIdx + 1);
                String css = "oddRow" + cOddOrEven[colIdx] + "Col";
                String message = "itemlist." + field;
                String markClass = "";
                if (field.startsWith("mark_")) {
                    markClass = " " + field + "_th";
                }
                out.print("<th id=\"" + id + "\" class=\"" + css + markClass + "\">" + (emph[colIdx] ? "<strong>" : "") + LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)message) + (emph[colIdx] ? "</strong>" : "") + "</th>");
            }
            if (this.linkToEdit) {
                String id = "t" + Integer.toString(cOddOrEven.length + 1);
                String css = "oddRow" + cOddOrEven[cOddOrEven.length - 2] + "Col";
                out.print("<th id=\"" + id + "\" class=\"" + css + "\">" + (emph[emph.length - 2] ? "<strong>" : "") + "&nbsp;" + (emph[emph.length - 2] ? "</strong>" : "") + "</th>");
            }
            out.print("</tr>");
            for (int i = 0; i < this.items.length; ++i) {
                out.print("<tr>");
                String rOddOrEven = i == this.highlightRow ? "highlight" : ((i & 1) == 1 ? "odd" : "even");
                for (int colIdx = 0; colIdx < fieldArr.length; ++colIdx) {
                    String field = fieldArr[colIdx];
                    StringTokenizer eq = new StringTokenizer(field, ".");
                    String[] tokens = new String[]{"", "", ""};
                    int k = 0;
                    while (eq.hasMoreTokens()) {
                        tokens[k] = eq.nextToken().toLowerCase().trim();
                        ++k;
                    }
                    String schema = tokens[0];
                    String element = tokens[1];
                    String qualifier = tokens[2];
                    Metadatum[] metadataArray = qualifier.equals("*") ? this.items[i].getMetadata(schema, element, "*", "*") : (qualifier.equals("") ? this.items[i].getMetadata(schema, element, null, "*") : this.items[i].getMetadata(schema, element, qualifier, "*"));
                    if (metadataArray == null) {
                        metadataArray = new Metadatum[]{};
                    }
                    String metadata = "-";
                    if (field.equals("thumbnail")) {
                        metadata = this.getThumbMarkup(hrq, this.items[i]);
                    } else if (field.startsWith("mark_")) {
                        metadata = UIUtil.getMarkingMarkup((HttpServletRequest)hrq, (DSpaceObject)this.items[i], (String)field);
                    }
                    if (metadataArray.length > 0) {
                        if (isDate[colIdx]) {
                            DCDate dd = new DCDate(metadataArray[0].value);
                            metadata = UIUtil.displayDate((DCDate)dd, (boolean)false, (boolean)false, (HttpServletRequest)hrq);
                        } else if (field.equals(titleField) && this.items[i].isWithdrawn()) {
                            metadata = Utils.addEntities((String)metadataArray[0].value);
                        } else if (field.equals(titleField)) {
                            metadata = "<a href=\"" + hrq.getContextPath() + "/handle/" + this.items[i].getHandle() + "\">" + Utils.addEntities((String)metadataArray[0].value) + "</a>";
                        } else {
                            boolean truncated = false;
                            int loopLimit = metadataArray.length;
                            if (isAuthor[colIdx]) {
                                int fieldMax = this.authorLimit > 0 ? this.authorLimit : metadataArray.length;
                                loopLimit = fieldMax > metadataArray.length ? metadataArray.length : fieldMax;
                                truncated = fieldMax < metadataArray.length;
                                log.debug((Object)("Limiting output of field " + field + " to " + Integer.toString(loopLimit) + " from an original " + Integer.toString(metadataArray.length)));
                            }
                            StringBuffer sb = new StringBuffer();
                            for (int j = 0; j < loopLimit; ++j) {
                                String startLink = "";
                                String endLink = "";
                                if (!StringUtils.isEmpty((String)browseType[colIdx]) && !this.disableCrossLinks) {
                                    String value;
                                    String argument;
                                    if (metadataArray[j].authority != null && metadataArray[j].confidence >= MetadataAuthorityManager.getManager().getMinConfidence(metadataArray[j].schema, metadataArray[j].element, metadataArray[j].qualifier)) {
                                        argument = "authority";
                                        value = metadataArray[j].authority;
                                    } else {
                                        argument = "value";
                                        value = metadataArray[j].value;
                                    }
                                    if (viewFull[colIdx]) {
                                        argument = "vfocus";
                                    }
                                    startLink = "<a href=\"" + hrq.getContextPath() + "/browse?type=" + browseType[colIdx] + "&amp;" + argument + "=" + URLEncoder.encode(value, "UTF-8");
                                    if (metadataArray[j].language != null) {
                                        startLink = startLink + "&amp;" + argument + "_lang=" + URLEncoder.encode(metadataArray[j].language, "UTF-8");
                                    }
                                    startLink = "authority".equals(argument) ? startLink + "\" class=\"authority " + browseType[colIdx] + "\">" : startLink + "\">";
                                    endLink = "</a>";
                                }
                                sb.append(startLink);
                                sb.append(Utils.addEntities((String)metadataArray[j].value));
                                sb.append(endLink);
                                if (j >= loopLimit - 1) continue;
                                sb.append("; ");
                            }
                            if (truncated) {
                                String etal = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"itemlist.et-al");
                                sb.append(", ").append(etal);
                            }
                            metadata = "<em>" + sb.toString() + "</em>";
                        }
                    } else if (field.equals(titleField)) {
                        String undefined = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"itemlist.title.undefined");
                        metadata = this.items[i].isWithdrawn() ? "<span style=\"font-style:italic\">(" + undefined + ")</span>" : "<a href=\"" + hrq.getContextPath() + "/handle/" + this.items[i].getHandle() + "\">" + "<span style=\"font-style:italic\">(" + undefined + ")</span>" + "</a>";
                    }
                    String extras = "";
                    if (isDate[colIdx]) {
                        extras = "nowrap=\"nowrap\" align=\"right\"";
                    }
                    String markClass = "";
                    if (field.startsWith("mark_")) {
                        markClass = " " + field + "_tr";
                    }
                    String id = "t" + Integer.toString(colIdx + 1);
                    out.print("<td headers=\"" + id + "\" class=\"" + rOddOrEven + "Row" + cOddOrEven[colIdx] + "Col" + markClass + "\" " + extras + ">" + (emph[colIdx] ? "<strong>" : "") + metadata + (emph[colIdx] ? "</strong>" : "") + "</td>");
                }
                if (this.linkToEdit) {
                    String id = "t" + Integer.toString(cOddOrEven.length + 1);
                    out.print("<td headers=\"" + id + "\" class=\"" + rOddOrEven + "Row" + cOddOrEven[cOddOrEven.length - 2] + "Col\" nowrap>" + "<form method=\"get\" action=\"" + hrq.getContextPath() + "/tools/edit-item\">" + "<input type=\"hidden\" name=\"handle\" value=\"" + this.items[i].getHandle() + "\" />" + "<input type=\"submit\" value=\"Edit Item\" /></form>" + "</td>");
                }
                out.println("</tr>");
            }
            out.println("</table>");
        }
        catch (IOException ie) {
            throw new JspException((Throwable)ie);
        }
        catch (BrowseException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    public int getAuthorLimit() {
        return this.authorLimit;
    }

    public void setAuthorLimit(int al) {
        this.authorLimit = al;
    }

    public boolean getLinkToEdit() {
        return this.linkToEdit;
    }

    public void setLinkToEdit(boolean edit) {
        this.linkToEdit = edit;
    }

    public boolean getDisableCrossLinks() {
        return this.disableCrossLinks;
    }

    public void setDisableCrossLinks(boolean links) {
        this.disableCrossLinks = links;
    }

    public SortOption getSortOption() {
        return this.sortOption;
    }

    public void setSortOption(SortOption so) {
        this.sortOption = so;
    }

    public Item[] getItems() {
        return (Item[])ArrayUtils.clone((Object[])this.items);
    }

    public void setItems(Item[] itemsIn) {
        this.items = (Item[])ArrayUtils.clone((Object[])itemsIn);
    }

    public String getHighlightrow() {
        return String.valueOf(this.highlightRow);
    }

    public void setHighlightrow(String highlightRowIn) {
        if (highlightRowIn == null || highlightRowIn.equals("")) {
            this.highlightRow = -1;
        } else {
            try {
                this.highlightRow = Integer.parseInt(highlightRowIn);
            }
            catch (NumberFormatException nfe) {
                this.highlightRow = -1;
            }
        }
    }

    public String getEmphcolumn() {
        return this.emphColumn;
    }

    public void setEmphcolumn(String emphColumnIn) {
        this.emphColumn = emphColumnIn;
    }

    public void release() {
        this.highlightRow = -1;
        this.emphColumn = null;
        this.items = null;
    }

    private static void getThumbSettings() {
        String linkBehaviour;
        showThumbs = ConfigurationManager.getBooleanProperty((String)"webui.browse.thumbnail.show");
        if (showThumbs) {
            thumbItemListMaxHeight = ConfigurationManager.getIntProperty((String)"webui.browse.thumbnail.maxheight");
            if (thumbItemListMaxHeight == 0) {
                thumbItemListMaxHeight = ConfigurationManager.getIntProperty((String)"thumbnail.maxheight");
            }
            if ((thumbItemListMaxWidth = ConfigurationManager.getIntProperty((String)"webui.browse.thumbnail.maxwidth")) == 0) {
                thumbItemListMaxWidth = ConfigurationManager.getIntProperty((String)"thumbnail.maxwidth");
            }
        }
        if ("bitstream".equals(linkBehaviour = ConfigurationManager.getProperty((String)"webui.browse.thumbnail.linkbehaviour"))) {
            linkToBitstream = true;
        }
    }

    private String getScalingAttr(HttpServletRequest hrq, Bitstream bitstream) throws JspException {
        float scale_factor;
        BufferedImage buf;
        try {
            Context c = UIUtil.obtainContext((HttpServletRequest)hrq);
            InputStream is = BitstreamStorageManager.retrieve((Context)c, (int)bitstream.getID());
            buf = ImageIO.read(is);
            is.close();
        }
        catch (SQLException sqle) {
            throw new JspException(sqle.getMessage(), (Throwable)sqle);
        }
        catch (IOException ioe) {
            throw new JspException(ioe.getMessage(), (Throwable)ioe);
        }
        float xsize = buf.getWidth(null);
        float ysize = buf.getHeight(null);
        if (xsize > (float)thumbItemListMaxWidth) {
            scale_factor = (float)thumbItemListMaxWidth / xsize;
            xsize *= scale_factor;
            ysize *= scale_factor;
        }
        if (ysize > (float)thumbItemListMaxHeight) {
            scale_factor = (float)thumbItemListMaxHeight / ysize;
            xsize *= scale_factor;
            ysize *= scale_factor;
        }
        StringBuffer sb = new StringBuffer("width=\"").append(xsize).append("\" height=\"").append(ysize).append("\"");
        return sb.toString();
    }

    private String getThumbMarkup(HttpServletRequest hrq, Item item) throws JspException {
        try {
            Context c = UIUtil.obtainContext((HttpServletRequest)hrq);
            Thumbnail thumbnail = ItemService.getThumbnail((Context)c, (int)item.getID(), (boolean)linkToBitstream);
            if (thumbnail == null) {
                return "";
            }
            StringBuffer thumbFrag = new StringBuffer();
            if (linkToBitstream) {
                Bitstream original = thumbnail.getOriginal();
                String link = hrq.getContextPath() + "/bitstream/" + item.getHandle() + "/" + original.getSequenceID() + "/" + UIUtil.encodeBitstreamName((String)original.getName(), (String)"UTF-8");
                thumbFrag.append("<a target=\"_blank\" href=\"" + link + "\" />");
            } else {
                String link = hrq.getContextPath() + "/handle/" + item.getHandle();
                thumbFrag.append("<a href=\"" + link + "\" />");
            }
            Bitstream thumb = thumbnail.getThumb();
            String img = hrq.getContextPath() + "/retrieve/" + thumb.getID() + "/" + UIUtil.encodeBitstreamName((String)thumb.getName(), (String)"UTF-8");
            String alt = thumb.getName();
            String scAttr = this.getScalingAttr(hrq, thumb);
            thumbFrag.append("<img src=\"").append(img).append("\" alt=\"").append(alt).append("\" ").append(scAttr).append("/ border=\"0\"></a>");
            return thumbFrag.toString();
        }
        catch (SQLException sqle) {
            throw new JspException(sqle.getMessage(), (Throwable)sqle);
        }
        catch (UnsupportedEncodingException e) {
            throw new JspException("Server does not support DSpace's default encoding. ", (Throwable)e);
        }
    }

    static {
        String authorLine;
        String titleLine;
        log = Logger.getLogger(ItemListTag.class);
        linkToBitstream = false;
        dateField = "dc.date.issued";
        titleField = "dc.title";
        authorField = "dc.contributor.*";
        ItemListTag.getThumbSettings();
        if (showThumbs) {
            DEFAULT_LIST_FIELDS = "thumbnail, dc.date.issued(date), dc.title, dc.contributor.*";
            DEFAULT_LIST_WIDTHS = "*, 130, 60%, 40%";
        } else {
            DEFAULT_LIST_FIELDS = "dc.date.issued(date), dc.title, dc.contributor.*";
            DEFAULT_LIST_WIDTHS = "130, 60%, 40%";
        }
        String dateLine = ConfigurationManager.getProperty((String)"webui.browse.index.date");
        if (dateLine != null) {
            dateField = dateLine;
        }
        if ((titleLine = ConfigurationManager.getProperty((String)"webui.browse.index.title")) != null) {
            titleField = titleLine;
        }
        if ((authorLine = ConfigurationManager.getProperty((String)"webui.browse.author-field")) != null) {
            authorField = authorLine;
        }
    }
}

