/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.jsptag;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.Group;

public class AccessSettingTag
extends TagSupport {
    private static Logger log = Logger.getLogger(AccessSettingTag.class);
    private static final boolean advanced = ConfigurationManager.getBooleanProperty((String)"webui.submission.restrictstep.enableAdvancedForm", (boolean)false);
    private static final String restrictedGroup = ConfigurationManager.getProperty((String)"webui.submission.restrictstep.groups");
    private transient SubmissionInfo subInfo = null;
    private transient DSpaceObject dso = null;
    private transient ResourcePolicy rp = null;
    private boolean embargo = false;
    private boolean hidden = false;
    private boolean addpolicy = false;

    public int doStartTag() throws JspException {
        String legend = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.access-setting.legend");
        String label_name = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.access-setting.label_name");
        String label_group = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.access-setting.label_group");
        String label_embargo = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.access-setting.label_embargo");
        String label_date = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.access-setting.label_date");
        String radio0 = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.access-setting.radio0");
        String radio1 = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.access-setting.radio1");
        String radio_help = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.access-setting.radio_help");
        String label_reason = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.access-setting.label_reason");
        String button_confirm = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.access-setting.button_confirm");
        String help_name = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.access-setting.name_help");
        String help_reason = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)"org.dspace.app.webui.jsptag.access-setting.reason_help");
        JspWriter out = this.pageContext.getOut();
        StringBuffer sb = new StringBuffer();
        try {
            HttpServletRequest hrq = (HttpServletRequest)this.pageContext.getRequest();
            Context context = UIUtil.obtainContext((HttpServletRequest)hrq);
            List policies = null;
            if (!advanced && this.dso != null) {
                policies = AuthorizeManager.findPoliciesByDSOAndType((Context)context, (DSpaceObject)this.dso, (String)ResourcePolicy.TYPE_CUSTOM);
            } else if (this.rp != null) {
                policies = new ArrayList<ResourcePolicy>();
                policies.add(this.rp);
            }
            String name = "";
            int group_id = 0;
            String startDate = "";
            String reason = "";
            String radio0Checked = " checked=\"checked\"";
            String radio1Checked = "";
            String disabled = " disabled=\"disabled\"";
            if (policies != null && policies.size() > 0) {
                ResourcePolicy rp = (ResourcePolicy)policies.get(0);
                name = rp.getRpName() == null ? "" : rp.getRpName();
                group_id = rp.getGroup().getID();
                startDate = rp.getStartDate() != null ? DateFormatUtils.format((Date)rp.getStartDate(), (String)"yyyy-MM-dd") : "";
                String string = reason = rp.getRpDescription() == null ? "" : rp.getRpDescription();
                if (!startDate.equals("")) {
                    radio0Checked = "";
                    radio1Checked = " checked=\"checked\"";
                    disabled = "";
                }
            }
            if (!advanced) {
                disabled = "";
            }
            if (this.embargo) {
                sb.append("<div class=\"form-group\">");
                sb.append(label_name).append("\n");
                sb.append("<p class=\"help-block\">").append(help_name).append("</p>").append("\n");
                sb.append("<input class=\"form-control\" name=\"name\" id=\"policy_name\" type=\"text\" maxlength=\"30\" value=\"").append(name).append("\" />\n");
                sb.append("</div>");
                sb.append("<div class=\"form-group\">");
                sb.append(label_group).append("\n");
                sb.append("<select class=\"form-control\" name=\"group_id\" id=\"select_group\">\n");
                Group[] groups = this.getGroups(context, hrq, this.subInfo);
                if (groups != null) {
                    for (Group group : groups) {
                        sb.append("<option value=\"").append(group.getID()).append("\"");
                        if (group_id == group.getID()) {
                            sb.append(" selected=\"selected\"");
                        }
                        sb.append(">").append(group.getName()).append("</option>\n");
                    }
                } else {
                    sb.append("<option value=\"0\" selected=\"selected\">Anonymous</option>\n");
                }
                sb.append("</select>\n");
                sb.append("</div>");
                sb.append(label_embargo).append("\n");
                sb.append("<div class=\"radio\">");
                sb.append("<label><input name=\"open_access_radios\" type=\"radio\" value=\"0\"").append(radio0Checked).append(" />").append(radio0).append("</label>\n");
                sb.append("</div>");
                sb.append("<div class=\"radio\">");
                sb.append("<label><input name=\"open_access_radios\" type=\"radio\" value=\"1\"").append(radio1Checked).append(" />").append(radio1).append("</label>\n");
                sb.append("</div>");
            }
            if (this.hidden) {
                sb.append("<input name=\"embargo_until_date\" id=\"embargo_until_date_hidden\" type=\"hidden\" value=\"").append(startDate).append("\" />\n");
                sb.append("<input name=\"reason\" id=\"reason_hidden\" type=\"hidden\" value=\"").append(reason).append("\" />\n");
            } else {
                sb.append("<div class=\"form-group col-md-12\">");
                sb.append("<div class=\"col-md-2\">");
                sb.append(label_date);
                sb.append("</div>");
                sb.append("<div class=\"col-md-2\">");
                sb.append("<input class=\"form-control\" name=\"embargo_until_date\" id=\"embargo_until_date\" maxlength=\"10\" size=\"10\" type=\"text\" value=\"").append(startDate).append("\"").append(disabled).append(" />\n");
                sb.append("</div>");
                sb.append("<div class=\"col-md-8\">");
                sb.append("<span class=\"help-block\">" + radio_help + "</span>");
                sb.append("</div>");
                sb.append("</div>");
                sb.append("<div class=\"form-group col-md-12\">");
                sb.append("<div class=\"col-md-12\">");
                sb.append(label_reason).append("\n");
                sb.append("</div>");
                sb.append("<div class=\"col-md-12\">");
                sb.append("<p class=\"help-block\">").append(help_reason).append("</p>").append("\n");
                sb.append("</div>");
                sb.append("<div class=\"col-md-12\">");
                sb.append("<textarea class=\"form-control\" name=\"reason\" id=\"reason\" cols=\"30\" rows=\"5\"").append(disabled).append(">").append(reason).append("</textarea>\n");
                sb.append("</div>");
                sb.append("</div>");
            }
            if (this.addpolicy) {
                sb.append("<input class=\"btn btn-success col-md-offset-5\" name=\"submit_add_policy\" type=\"submit\" value=\"").append(button_confirm).append("\" />\n");
            }
            out.println(sb.toString());
        }
        catch (IOException ie) {
            throw new JspException((Throwable)ie);
        }
        catch (SQLException e) {
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    public SubmissionInfo getSubInfo() {
        return this.subInfo;
    }

    public void setSubInfo(SubmissionInfo subInfo) {
        this.subInfo = subInfo;
    }

    public DSpaceObject getDso() {
        return this.dso;
    }

    public void setDso(DSpaceObject dso) {
        this.dso = dso;
    }

    public ResourcePolicy getRp() {
        return this.rp;
    }

    public void setRp(ResourcePolicy rp) {
        this.rp = rp;
    }

    public boolean getEmbargo() {
        return this.embargo;
    }

    public void setEmbargo(boolean embargo) {
        this.embargo = embargo;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setAddpolicy(boolean addpolicy) {
        this.addpolicy = addpolicy;
    }

    public boolean getAddpolicy() {
        return this.addpolicy;
    }

    public void release() {
        this.dso = null;
        this.subInfo = null;
        this.rp = null;
        this.embargo = false;
        this.hidden = false;
        this.addpolicy = false;
    }

    private Group[] getGroups(Context context, HttpServletRequest request, SubmissionInfo subInfo) throws SQLException {
        Group uiGroup;
        Group[] groups = null;
        if (restrictedGroup != null && (uiGroup = Group.findByName((Context)context, (String)restrictedGroup)) != null) {
            groups = uiGroup.getMemberGroups();
        }
        if (groups == null || groups.length == 0) {
            groups = Group.findAll((Context)context, (int)1);
        }
        return groups;
    }
}

