/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.TransformationEngine;
import gr.ekt.bte.core.TransformationSpec;
import gr.ekt.bte.exceptions.BadTransformationSpec;
import gr.ekt.bte.exceptions.MalformedSourceException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.webui.json.JSONRequest;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.Utils;
import org.dspace.submit.lookup.MultipleSubmissionLookupDataLoader;
import org.dspace.submit.lookup.SubmissionLookupOutputGenerator;
import org.dspace.submit.lookup.SubmissionLookupService;
import org.dspace.submit.lookup.SubmissionLookupUtils;
import org.dspace.submit.util.ItemSubmissionLookupDTO;
import org.dspace.submit.util.SubmissionLookupDTO;
import org.dspace.utils.DSpace;

public class SubmissionLookupJSONRequest
extends JSONRequest {
    private SubmissionLookupService service = (SubmissionLookupService)new DSpace().getServiceManager().getServiceByName(SubmissionLookupService.class.getName(), SubmissionLookupService.class);
    private static Logger log = Logger.getLogger(SubmissionLookupJSONRequest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doJSONRequest(Context context, HttpServletRequest req, HttpServletResponse resp) throws AuthorizeException, IOException {
        Gson json = new Gson();
        String suuid = req.getParameter("s_uuid");
        SubmissionLookupDTO subDTO = this.service.getSubmissionLookupDTO(req, suuid);
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
        if ("identifiers".equalsIgnoreCase(req.getParameter("type"))) {
            HashMap identifiers = new HashMap();
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String parameterName = (String)e.nextElement();
                String parameterValue = req.getParameter(parameterName);
                if (!parameterName.startsWith("identifier_") || !StringUtils.isNotBlank((String)parameterValue)) continue;
                HashSet<String> set = new HashSet<String>();
                set.add(parameterValue);
                identifiers.put(parameterName.substring("identifier_".length()), set);
            }
            List result = new ArrayList();
            TransformationEngine transformationEngine = this.service.getPhase1TransformationEngine();
            if (transformationEngine != null) {
                MultipleSubmissionLookupDataLoader dataLoader = (MultipleSubmissionLookupDataLoader)transformationEngine.getDataLoader();
                dataLoader.setIdentifiers(identifiers);
                try {
                    SubmissionLookupOutputGenerator outputGenerator = (SubmissionLookupOutputGenerator)transformationEngine.getOutputGenerator();
                    outputGenerator.setDtoList(new ArrayList());
                    log.debug((Object)"BTE transformation is about to start!");
                    transformationEngine.transform(new TransformationSpec());
                    log.debug((Object)"BTE transformation finished!");
                    result = outputGenerator.getDtoList();
                }
                catch (BadTransformationSpec e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
                catch (MalformedSourceException e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
            subDTO.setItems(result);
            this.service.storeDTOs(req, suuid, subDTO);
            List dto = this.getLightResultList(result);
            JsonElement tree = json.toJsonTree((Object)dto);
            JsonObject jo = new JsonObject();
            jo.add("result", tree);
            resp.getWriter().write(jo.toString());
        } else if ("search".equalsIgnoreCase(req.getParameter("type"))) {
            String title = req.getParameter("title");
            String author = req.getParameter("authors");
            int year = UIUtil.getIntParameter((HttpServletRequest)req, (String)"year");
            HashMap searchTerms = new HashMap();
            HashSet<String> tmp1 = new HashSet<String>();
            tmp1.add(title);
            HashSet<String> tmp2 = new HashSet<String>();
            tmp2.add(author);
            HashSet<String> tmp3 = new HashSet<String>();
            tmp3.add(String.valueOf(year));
            searchTerms.put("title", tmp1);
            searchTerms.put("authors", tmp2);
            searchTerms.put("year", tmp3);
            List result = new ArrayList();
            TransformationEngine transformationEngine = this.service.getPhase1TransformationEngine();
            if (transformationEngine != null) {
                MultipleSubmissionLookupDataLoader dataLoader = (MultipleSubmissionLookupDataLoader)transformationEngine.getDataLoader();
                dataLoader.setSearchTerms(searchTerms);
                try {
                    SubmissionLookupOutputGenerator outputGenerator = (SubmissionLookupOutputGenerator)transformationEngine.getOutputGenerator();
                    outputGenerator.setDtoList(new ArrayList());
                    log.debug((Object)"BTE transformation is about to start!");
                    transformationEngine.transform(new TransformationSpec());
                    log.debug((Object)"BTE transformation finished!");
                    result = outputGenerator.getDtoList();
                }
                catch (BadTransformationSpec e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
                catch (MalformedSourceException e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
            subDTO.setItems(result);
            this.service.storeDTOs(req, suuid, subDTO);
            List dto = this.getLightResultList(result);
            JsonElement tree = json.toJsonTree((Object)dto);
            JsonObject jo = new JsonObject();
            jo.add("result", tree);
            resp.getWriter().write(jo.toString());
        } else if ("details".equalsIgnoreCase(req.getParameter("type"))) {
            String i_uuid = req.getParameter("i_uuid");
            Map dto = this.getDetails(subDTO.getLookupItem(i_uuid), context);
            JsonElement tree = json.toJsonTree((Object)dto);
            JsonObject jo = new JsonObject();
            jo.add("result", tree);
            resp.getWriter().write(jo.toString());
        } else if (isMultipart) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            HashMap<String, String> valueMap = new HashMap<String, String>();
            InputStream io = null;
            Object filename = null;
            try {
                List iter = upload.parseRequest(req);
                for (FileItem item : iter) {
                    String name = item.getFieldName();
                    InputStream stream = item.getInputStream();
                    if (item.isFormField()) {
                        String value = Streams.asString((InputStream)stream);
                        valueMap.put(name, value);
                        continue;
                    }
                    io = stream;
                }
            }
            catch (FileUploadException e) {
                throw new IOException(e);
            }
            suuid = (String)valueMap.get("s_uuid");
            subDTO = this.service.getSubmissionLookupDTO(req, suuid);
            List result = new ArrayList();
            TransformationEngine transformationEngine = this.service.getPhase1TransformationEngine();
            if (transformationEngine != null) {
                MultipleSubmissionLookupDataLoader dataLoader = (MultipleSubmissionLookupDataLoader)transformationEngine.getDataLoader();
                String tempDir = ConfigurationManager.getProperty((String)"upload.temp.dir") != null ? ConfigurationManager.getProperty((String)"upload.temp.dir") : System.getProperty("java.io.tmpdir");
                File uploadDir = new File(tempDir);
                if (!uploadDir.exists() && !uploadDir.mkdir()) {
                    uploadDir = null;
                }
                File file = File.createTempFile("submissionlookup-loader", ".temp", uploadDir);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                Utils.bufferedCopy((InputStream)io, (OutputStream)out);
                dataLoader.setFile(file.getAbsolutePath(), (String)valueMap.get("provider_loader"));
                try {
                    SubmissionLookupOutputGenerator outputGenerator = (SubmissionLookupOutputGenerator)transformationEngine.getOutputGenerator();
                    outputGenerator.setDtoList(new ArrayList());
                    log.debug((Object)"BTE transformation is about to start!");
                    transformationEngine.transform(new TransformationSpec());
                    log.debug((Object)"BTE transformation finished!");
                    result = outputGenerator.getDtoList();
                }
                catch (BadTransformationSpec e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
                catch (MalformedSourceException e1) {
                    log.error((Object)e1.getMessage(), (Throwable)e1);
                }
                finally {
                    file.delete();
                }
            }
            subDTO.setItems(result);
            this.service.storeDTOs(req, suuid, subDTO);
            List dto = this.getLightResultList(result);
            if (valueMap.containsKey("skip_loader") && ((String)valueMap.get("skip_loader")).equals("true")) {
                HashMap<String, Object> skip = new HashMap<String, Object>();
                skip.put("skip", Boolean.TRUE);
                skip.put("uuid", valueMap.containsKey("s_uuid") ? suuid : Integer.valueOf(-1));
                skip.put("collectionid", valueMap.containsKey("select-collection-file") ? (Serializable)valueMap.get("select-collection-file") : Integer.valueOf(-1));
                dto.add(skip);
            }
            JsonElement tree = json.toJsonTree((Object)dto);
            JsonObject jo = new JsonObject();
            jo.add("result", tree);
            resp.setContentType("text/plain");
            resp.getWriter().write(jo.toString());
        }
    }

    private Map<String, Object> getDetails(ItemSubmissionLookupDTO item, Context context) {
        List fieldOrder = this.getFieldOrder();
        Record totalData = item.getTotalPublication(this.service.getProviders());
        Set availableFields = totalData.getFields();
        ArrayList<String[]> fieldsLabels = new ArrayList<String[]>();
        for (String f : fieldOrder) {
            if (!availableFields.contains(f)) continue;
            try {
                if (totalData.getValues(f) == null || totalData.getValues(f).size() <= 0) continue;
                fieldsLabels.add(new String[]{f, I18nUtil.getMessage((String)("jsp.submission-lookup.detail." + f), (Context)context)});
            }
            catch (MissingResourceException e) {
                fieldsLabels.add(new String[]{f, f});
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        String uuid = item.getUUID();
        Record pub = item.getTotalPublication(this.service.getProviders());
        HashMap<String, List> publication1 = new HashMap<String, List>();
        for (String field : pub.getFields()) {
            publication1.put(field, SubmissionLookupUtils.getValues((Record)pub, (String)field));
        }
        data.put("uuid", uuid);
        data.put("providers", item.getProviders());
        data.put("publication", publication1);
        data.put("fieldsLabels", fieldsLabels);
        return data;
    }

    private List<String> getFieldOrder() {
        if (this.service.getDetailFields() != null) {
            return this.service.getDetailFields();
        }
        ArrayList<String> defaultValues = new ArrayList<String>();
        defaultValues.add("title");
        defaultValues.add("authors");
        defaultValues.add("editors");
        defaultValues.add("translators");
        defaultValues.add("chairs");
        defaultValues.add("issued");
        defaultValues.add("abstract");
        defaultValues.add("doi");
        defaultValues.add("journal");
        defaultValues.add("volume");
        defaultValues.add("issue");
        defaultValues.add("publisher");
        defaultValues.add("jissn");
        defaultValues.add("pisbn");
        defaultValues.add("eisbn");
        defaultValues.add("arxivCategory");
        defaultValues.add("keywords");
        defaultValues.add("mesh");
        defaultValues.add("language");
        defaultValues.add("subtype");
        defaultValues.add("translators");
        return defaultValues;
    }

    private List<Map<String, Object>> getLightResultList(List<ItemSubmissionLookupDTO> result) {
        ArrayList<Map<String, Object>> publications = new ArrayList<Map<String, Object>>();
        if (result != null && result.size() > 0) {
            for (ItemSubmissionLookupDTO item : result) {
                String uuid = item.getUUID();
                Record pub = item.getTotalPublication(this.service.getProviders());
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("uuid", uuid);
                data.put("providers", item.getProviders());
                data.put("title", SubmissionLookupUtils.getFirstValue((Record)pub, (String)"title"));
                data.put("authors", pub.getValues("authors") != null ? StringUtils.join(SubmissionLookupUtils.getValues((Record)pub, (String)"authors").iterator(), (String)", ") : "");
                data.put("issued", SubmissionLookupUtils.getFirstValue((Record)pub, (String)"issued"));
                publications.add(data);
            }
        }
        return publications;
    }
}

