/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.filter;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.Authenticate;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class ShibbolethFilter
implements Filter {
    private static Logger log = Logger.getLogger(ShibbolethFilter.class);

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        Context context = null;
        HttpServletRequest hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = (HttpServletResponse)response;
        try {
            context = UIUtil.obtainContext((HttpServletRequest)hrequest);
            if (context.getCurrentUser() == null) {
                Enumeration names = ((HttpServletRequest)request).getHeaderNames();
                while (names.hasMoreElements()) {
                    String name = names.nextElement().toString();
                    log.debug((Object)("header:" + name + "=" + ((HttpServletRequest)request).getHeader(name)));
                }
            } else {
                chain.doFilter((ServletRequest)hrequest, (ServletResponse)hresponse);
                return;
            }
            Authenticate.startAuthentication((Context)context, (HttpServletRequest)hrequest, (HttpServletResponse)hresponse);
        }
        catch (SQLException se) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"database_error", (String)se.toString()), (Throwable)se);
            JSPManager.showInternalError((HttpServletRequest)hrequest, (HttpServletResponse)hresponse);
        }
        if (context != null && context.isValid()) {
            context.abort();
        }
    }

    public void destroy() {
    }
}

