/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.components;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.VersionUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.plugin.ItemHomeProcessor;
import org.dspace.plugin.PluginException;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;

public class VersioningItemHome
implements ItemHomeProcessor {
    private static Logger log = Logger.getLogger(VersioningItemHome.class);

    public void process(Context context, HttpServletRequest request, HttpServletResponse response, Item item) throws PluginException, AuthorizeException {
        boolean versioningEnabled = ConfigurationManager.getBooleanProperty((String)"versioning", (String)"enabled");
        boolean newVersionAvailable = false;
        boolean showVersionWorkflowAvailable = false;
        boolean hasVersionButton = false;
        boolean hasVersionHistory = false;
        VersionHistory history = null;
        ArrayList<Version> historyVersions = new ArrayList<Version>();
        String latestVersionHandle = null;
        String latestVersionURL = null;
        if (versioningEnabled) {
            Version latestVersion;
            try {
                if (item.canEdit() && VersionUtil.isLatest((Context)context, (Item)item) && item.isArchived()) {
                    hasVersionButton = true;
                }
            }
            catch (SQLException e) {
                throw new PluginException(e.getMessage());
            }
            if (VersionUtil.hasVersionHistory((Context)context, (Item)item)) {
                hasVersionHistory = true;
                history = VersionUtil.retrieveVersionHistory((Context)context, (Item)item);
                for (Version versRow : history.getVersions()) {
                    try {
                        if (VersionUtil.isItemInSubmission((Context)context, (Item)versRow.getItem())) continue;
                        historyVersions.add(versRow);
                    }
                    catch (SQLException e) {
                        throw new PluginException(e.getMessage());
                    }
                }
            }
            try {
                latestVersion = VersionUtil.checkLatestVersion((Context)context, (Item)item);
            }
            catch (SQLException e) {
                throw new PluginException(e.getMessage());
            }
            if (latestVersion != null && latestVersion != null && latestVersion.getItemID() != item.getID()) {
                Item latestVersionItem = latestVersion.getItem();
                if (latestVersionItem.isArchived()) {
                    newVersionAvailable = true;
                    try {
                        latestVersionURL = HandleManager.resolveToURL((Context)context, (String)latestVersionItem.getHandle());
                    }
                    catch (SQLException e) {
                        throw new PluginException(e.getMessage());
                    }
                    latestVersionHandle = latestVersionItem.getHandle();
                } else {
                    showVersionWorkflowAvailable = true;
                }
            }
        }
        request.setAttribute("versioning.enabled", (Object)versioningEnabled);
        request.setAttribute("versioning.hasversionbutton", (Object)hasVersionButton);
        request.setAttribute("versioning.hasversionhistory", (Object)hasVersionHistory);
        request.setAttribute("versioning.history", (Object)history);
        request.setAttribute("versioning.historyversions", historyVersions);
        request.setAttribute("versioning.newversionavailable", (Object)newVersionAvailable);
        request.setAttribute("versioning.showversionwfavailable", (Object)showVersionWorkflowAvailable);
        request.setAttribute("versioning.latestversionhandle", latestVersionHandle);
        request.setAttribute("versioning.latestversionurl", (Object)latestVersionURL);
    }
}

