/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.components;

import org.apache.log4j.Logger;
import org.dspace.app.webui.components.RecentSubmissions;
import org.dspace.app.webui.components.RecentSubmissionsException;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowserScope;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;

public class RecentSubmissionsManager {
    private static Logger log = Logger.getLogger(RecentSubmissionsManager.class);
    private Context context;

    public RecentSubmissionsManager(Context context) {
        this.context = context;
    }

    public RecentSubmissions getRecentSubmissions(DSpaceObject dso) throws RecentSubmissionsException {
        try {
            String source = ConfigurationManager.getProperty((String)"recent.submissions.sort-option");
            String count = ConfigurationManager.getProperty((String)"recent.submissions.count");
            BrowseEngine be = new BrowseEngine(this.context);
            BrowserScope bs = new BrowserScope(this.context);
            BrowseIndex bi = BrowseIndex.getItemBrowseIndex();
            bs.setBrowseIndex(bi);
            bs.setOrder("DESC");
            bs.setResultsPerPage(Integer.parseInt(count));
            if (dso != null) {
                bs.setBrowseContainer(dso);
            }
            for (SortOption so : SortOption.getSortOptions()) {
                if (!so.getName().equals(source)) continue;
                bs.setSortBy(so.getNumber());
            }
            BrowseInfo results = be.browseMini(bs);
            Item[] items = results.getItemResults(this.context);
            RecentSubmissions rs = new RecentSubmissions(items);
            return rs;
        }
        catch (SortException se) {
            log.error((Object)"caught exception: ", (Throwable)se);
            throw new RecentSubmissionsException((Throwable)se);
        }
        catch (BrowseException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new RecentSubmissionsException((Throwable)e);
        }
    }
}

