/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class JSPManager {
    private static Logger log = Logger.getLogger(JSPManager.class);

    public static void showJSP(HttpServletRequest request, HttpServletResponse response, String jsp) throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader((Context)((Context)request.getAttribute("dspace.context")), (String)"view_jsp", (String)jsp));
        }
        request.getRequestDispatcher(jsp).forward((ServletRequest)request, (ServletResponse)response);
    }

    public static void showInternalError(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(500);
        JSPManager.showJSP(request, response, "/error/internal.jsp");
    }

    public static void showIntegrityError(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(400);
        JSPManager.showJSP(request, response, "/error/integrity.jsp");
    }

    public static void showAuthorizeError(HttpServletRequest request, HttpServletResponse response, AuthorizeException exception) throws ServletException, IOException {
        response.setStatus(403);
        JSPManager.showJSP(request, response, "/error/authorize.jsp");
    }

    public static void showInvalidIDError(HttpServletRequest request, HttpServletResponse response, String badID, int type) throws ServletException, IOException {
        request.setAttribute("bad.id", (Object)StringEscapeUtils.escapeHtml((String)badID));
        response.setStatus(404);
        if (type != -1) {
            request.setAttribute("bad.type", (Object)type);
        }
        JSPManager.showJSP(request, response, "/error/invalid-id.jsp");
    }

    public static void showFileSizeLimitExceededError(HttpServletRequest request, HttpServletResponse response, String message, long actualSize, long permittedSize) throws ServletException, IOException {
        request.setAttribute("error.message", (Object)message);
        request.setAttribute("actualSize", (Object)actualSize);
        request.setAttribute("permittedSize", (Object)permittedSize);
        response.setStatus(413);
        JSPManager.showJSP(request, response, "/error/exceeded-size.jsp");
    }
}

