/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.webui.submit.JSPStep;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;

public class JSPSelectCollectionStep
extends JSPStep {
    private static final String SELECT_COLLECTION_JSP = "/submit/select-collection.jsp";
    private static Logger log = Logger.getLogger(JSPSelectCollectionStep.class);

    @Override
    public void doPreProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String collectionID = request.getParameter("collection");
        Collection col = null;
        if (collectionID != null) {
            col = Collection.find((Context)context, (int)Integer.parseInt(collectionID));
        }
        if (col != null) {
            log.debug((Object)("Select Collection page skipped, since a Collection ID was already found.  Collection ID=" + collectionID));
        } else {
            Community com = UIUtil.getCommunityLocation(request);
            Collection[] collections = com != null ? Collection.findAuthorized((Context)context, (Community)com, (int)3) : Collection.findAuthorized((Context)context, null, (int)3);
            if (collectionID != null && Integer.parseInt(collectionID) == -1) {
                request.setAttribute("no.collection", (Object)Boolean.TRUE);
            }
            request.setAttribute("collections", (Object)collections);
            JSPStepManager.showJSP(request, response, subInfo, SELECT_COLLECTION_JSP);
        }
    }

    @Override
    public void doPostProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int status) throws ServletException, IOException, SQLException, AuthorizeException {
        if (status == 1) {
            request.setAttribute("no.collection", (Object)Boolean.TRUE);
            this.doPreProcessing(context, request, response, subInfo);
        } else if (status == 2) {
            JSPManager.showInvalidIDError(request, response, request.getParameter("collection"), 3);
        }
    }

    @Override
    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        return "";
    }
}

