/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.service;

import java.sql.SQLException;
import org.dspace.app.iiif.model.generator.CanvasGenerator;
import org.dspace.app.iiif.service.AbstractResourceService;
import org.dspace.app.iiif.service.CanvasService;
import org.dspace.app.iiif.service.utils.IIIFUtils;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
@Component
public class CanvasLookupService
extends AbstractResourceService {
    @Autowired
    IIIFUtils utils;
    @Autowired
    CanvasService canvasService;

    public CanvasLookupService(ConfigurationService configurationService) {
        this.setConfiguration(configurationService);
    }

    public String generateCanvas(Context context, Item item, String canvasId) {
        CanvasGenerator canvasGenerator;
        int canvasPosition = this.utils.getCanvasId(canvasId);
        Bitstream bitstream = this.utils.getBitstreamForCanvas(context, item, canvasPosition);
        if (bitstream == null) {
            throw new ResourceNotFoundException();
        }
        String mimeType = this.utils.getBitstreamMimeType(bitstream, context);
        try {
            canvasGenerator = this.canvasService.getCanvas(context, item.getID().toString(), bitstream, (Bundle)bitstream.getBundles().get(0), item, canvasPosition, mimeType);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return this.utils.asJson(canvasGenerator.generateResource());
    }
}

