/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.model.generator;

import de.digitalcollections.iiif.model.ImageContent;
import de.digitalcollections.iiif.model.MetadataEntry;
import de.digitalcollections.iiif.model.sharedcanvas.Canvas;
import de.digitalcollections.iiif.model.sharedcanvas.Resource;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.dspace.app.iiif.model.generator.IIIFResource;
import org.dspace.app.iiif.model.generator.MetadataEntryGenerator;

public class CanvasGenerator
implements IIIFResource {
    private final String identifier;
    private final List<MetadataEntry> metadata = new ArrayList<MetadataEntry>();
    private final List<ImageContent> images = new ArrayList<ImageContent>();
    private String label;
    private Integer height;
    private Integer width;
    private ImageContent thumbnail;

    public CanvasGenerator(@NotNull String identifier) {
        if (identifier.isEmpty()) {
            throw new RuntimeException("Invalid canvas identifier. Cannot be an empty string.");
        }
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public CanvasGenerator setLabel(String label) {
        this.label = label;
        return this;
    }

    public CanvasGenerator setHeight(int height) {
        this.height = height;
        return this;
    }

    public CanvasGenerator setWidth(int width) {
        this.width = width;
        return this;
    }

    public CanvasGenerator addImage(Resource<ImageContent> imageContent) {
        this.images.add((ImageContent)imageContent);
        return this;
    }

    public CanvasGenerator addThumbnail(Resource<ImageContent> thumbnail) {
        this.thumbnail = (ImageContent)thumbnail;
        return this;
    }

    public void addMetadata(String field, String value, String ... rest) {
        MetadataEntryGenerator metadataEntryGenerator = new MetadataEntryGenerator();
        metadataEntryGenerator.setField(field);
        metadataEntryGenerator.setValue(value, rest);
        this.metadata.add(metadataEntryGenerator.generateValue());
    }

    public Resource<Canvas> generateResource() {
        if (this.identifier == null) {
            throw new RuntimeException("The Canvas resource requires an identifier.");
        }
        Canvas canvas = this.label != null ? new Canvas(this.identifier, this.label) : new Canvas(this.identifier);
        if (this.images.size() > 0) {
            if (this.height == null || this.width == null) {
                throw new RuntimeException("The Canvas resource requires both height and width dimensions.");
            }
            canvas.setWidth(this.width);
            canvas.setHeight(this.height);
            for (ImageContent res : this.images) {
                canvas.addImage(res, new ImageContent[0]);
            }
            if (this.thumbnail != null) {
                canvas.addThumbnail(new ImageContent[]{this.thumbnail});
            }
        }
        if (this.metadata.size() > 0) {
            for (MetadataEntry meta : this.metadata) {
                canvas.addMetadata(new MetadataEntry[]{meta});
            }
        }
        return canvas;
    }
}

