/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif;

import java.util.UUID;
import org.dspace.app.iiif.IIIFServiceFacade;
import org.dspace.core.Context;
import org.dspace.web.ContextUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iiif"})
@ConditionalOnProperty(value={"iiif.enabled"})
public class IIIFController {
    @Autowired
    IIIFServiceFacade iiifFacade;

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}/manifest"})
    public String findOne(@PathVariable UUID id) {
        Context context = ContextUtil.obtainCurrentRequestContext();
        return this.iiifFacade.getManifest(context, id);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}/manifest/search"})
    public String searchInManifest(@PathVariable UUID id, @RequestParam(name="q") String query) {
        Context context = ContextUtil.obtainCurrentRequestContext();
        return this.iiifFacade.searchInManifest(context, id, query);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}/manifest/seeAlso"})
    public String findSeeAlsoList(@PathVariable UUID id) {
        Context context = ContextUtil.obtainCurrentRequestContext();
        return this.iiifFacade.getSeeAlsoAnnotations(context, id);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}/canvas/{cid}"})
    public String findCanvas(@PathVariable UUID id, @PathVariable String cid) {
        Context context = ContextUtil.obtainCurrentRequestContext();
        return this.iiifFacade.getCanvas(context, id, cid);
    }
}

