/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.iiif.model.generator;

import de.digitalcollections.iiif.model.Profile;
import de.digitalcollections.iiif.model.Service;
import de.digitalcollections.iiif.model.search.ContentSearchService;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.dspace.app.iiif.model.generator.IIIFService;
import org.dspace.app.iiif.model.generator.ProfileGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
@Component
public class ContentSearchGenerator
implements IIIFService {
    private String identifier;
    private String label;
    @Autowired
    ProfileGenerator profile;

    public void setIdentifier(@NotNull String identifier) {
        if (identifier.isEmpty()) {
            throw new RuntimeException("The search service requires an identifier.");
        }
        this.identifier = identifier;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Service generateService() {
        if (this.identifier == null) {
            throw new RuntimeException("You must provide an identifier for the search service.");
        }
        ContentSearchService contentSearchService = new ContentSearchService(this.identifier);
        if (this.label != null) {
            contentSearchService.setLabel(this.label);
        }
        try {
            contentSearchService.setContext(new URI("http://iiif.io/api/search/0/context.json"));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        this.profile.setIdentifier("http://iiif.io/api/search/0/search");
        profiles.add(this.profile.generateValue());
        contentSearchService.setProfiles(profiles);
        return contentSearchService;
    }
}

