/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning.utils;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Relationship;

public class RelationshipVersioningUtils {
    private static final Logger log = LogManager.getLogger(RelationshipVersioningUtils.class);

    public boolean otherSideIsLatest(boolean isLeft, Relationship.LatestVersionStatus latestVersionStatus) {
        if (latestVersionStatus == Relationship.LatestVersionStatus.BOTH) {
            return true;
        }
        return latestVersionStatus == (isLeft ? Relationship.LatestVersionStatus.RIGHT_ONLY : Relationship.LatestVersionStatus.LEFT_ONLY);
    }

    public LatestVersionStatusChangelog updateLatestVersionStatus(Relationship relationship, boolean updateLeftSide, boolean isLatest) throws IllegalStateException {
        Relationship.LatestVersionStatus newVersionStatus;
        boolean rightSideIsLatest;
        Relationship.LatestVersionStatus lvs = relationship.getLatestVersionStatus();
        boolean leftSideIsLatest = lvs == Relationship.LatestVersionStatus.BOTH || lvs == Relationship.LatestVersionStatus.LEFT_ONLY;
        boolean bl = rightSideIsLatest = lvs == Relationship.LatestVersionStatus.BOTH || lvs == Relationship.LatestVersionStatus.RIGHT_ONLY;
        if (updateLeftSide) {
            if (leftSideIsLatest == isLatest) {
                return LatestVersionStatusChangelog.NO_CHANGES;
            }
            leftSideIsLatest = isLatest;
        } else {
            if (rightSideIsLatest == isLatest) {
                return LatestVersionStatusChangelog.NO_CHANGES;
            }
            rightSideIsLatest = isLatest;
        }
        if (leftSideIsLatest && rightSideIsLatest) {
            newVersionStatus = Relationship.LatestVersionStatus.BOTH;
        } else if (leftSideIsLatest) {
            newVersionStatus = Relationship.LatestVersionStatus.LEFT_ONLY;
        } else if (rightSideIsLatest) {
            newVersionStatus = Relationship.LatestVersionStatus.RIGHT_ONLY;
        } else {
            String msg = String.format("Illegal state: cannot set %s item to latest = false, because relationship with id %s, rightward name %s between left item with uuid %s, handle %s and right item with uuid %s, handle %s has latest version status set to %s", new Object[]{updateLeftSide ? "left" : "right", relationship.getID(), relationship.getRelationshipType().getRightwardType(), relationship.getLeftItem().getID(), relationship.getLeftItem().getHandle(), relationship.getRightItem().getID(), relationship.getRightItem().getHandle(), lvs});
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        log.info("set latest version status from {} to {} for relationship with id {}, rightward name {} between left item with uuid {}, handle {} and right item with uuid {}, handle {}", (Object)lvs, (Object)newVersionStatus, (Object)relationship.getID(), (Object)relationship.getRelationshipType().getRightwardType(), (Object)relationship.getLeftItem().getID(), (Object)relationship.getLeftItem().getHandle(), (Object)relationship.getRightItem().getID(), (Object)relationship.getRightItem().getHandle());
        relationship.setLatestVersionStatus(newVersionStatus);
        return updateLeftSide ? LatestVersionStatusChangelog.LEFT_SIDE_CHANGED : LatestVersionStatusChangelog.RIGHT_SIDE_CHANGED;
    }

    public static enum LatestVersionStatusChangelog {
        NO_CHANGES,
        LEFT_SIDE_CHANGED,
        RIGHT_SIDE_CHANGED;

    }
}

