/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.model.validator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.orcid.model.validator.OrcidValidationError;
import org.dspace.orcid.model.validator.OrcidValidator;
import org.dspace.services.ConfigurationService;
import org.orcid.jaxb.model.v3.release.common.DisambiguatedOrganization;
import org.orcid.jaxb.model.v3.release.common.Organization;
import org.orcid.jaxb.model.v3.release.common.OrganizationAddress;
import org.orcid.jaxb.model.v3.release.common.PublicationDate;
import org.orcid.jaxb.model.v3.release.common.Year;
import org.orcid.jaxb.model.v3.release.record.ExternalIDs;
import org.orcid.jaxb.model.v3.release.record.Funding;
import org.orcid.jaxb.model.v3.release.record.FundingTitle;
import org.orcid.jaxb.model.v3.release.record.Work;
import org.orcid.jaxb.model.v3.release.record.WorkTitle;

public class OrcidValidatorImpl
implements OrcidValidator {
    private final ConfigurationService configurationService;

    public OrcidValidatorImpl(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public List<OrcidValidationError> validate(Object object) {
        if (object instanceof Work && this.isWorkValidationEnabled()) {
            return this.validateWork((Work)object);
        }
        if (object instanceof Funding && this.isFundingValidationEnabled()) {
            return this.validateFunding((Funding)object);
        }
        return Collections.emptyList();
    }

    @Override
    public List<OrcidValidationError> validateWork(Work work) {
        PublicationDate publicationDate;
        ExternalIDs externalIdentifiers;
        ArrayList<OrcidValidationError> errors = new ArrayList<OrcidValidationError>();
        WorkTitle title = work.getWorkTitle();
        if (title == null || title.getTitle() == null || StringUtils.isBlank((CharSequence)title.getTitle().getContent())) {
            errors.add(OrcidValidationError.TITLE_REQUIRED);
        }
        if (work.getWorkType() == null) {
            errors.add(OrcidValidationError.TYPE_REQUIRED);
        }
        if ((externalIdentifiers = work.getExternalIdentifiers()) == null || CollectionUtils.isEmpty((Collection)externalIdentifiers.getExternalIdentifier())) {
            errors.add(OrcidValidationError.EXTERNAL_ID_REQUIRED);
        }
        if ((publicationDate = work.getPublicationDate()) != null && this.isYearNotValid(publicationDate)) {
            errors.add(OrcidValidationError.PUBLICATION_DATE_INVALID);
        }
        return errors;
    }

    @Override
    public List<OrcidValidationError> validateFunding(Funding funding) {
        ExternalIDs externalIdentifiers;
        ArrayList<OrcidValidationError> errors = new ArrayList<OrcidValidationError>();
        FundingTitle title = funding.getTitle();
        if (title == null || title.getTitle() == null || StringUtils.isBlank((CharSequence)title.getTitle().getContent())) {
            errors.add(OrcidValidationError.TITLE_REQUIRED);
        }
        if ((externalIdentifiers = funding.getExternalIdentifiers()) == null || CollectionUtils.isEmpty((Collection)externalIdentifiers.getExternalIdentifier())) {
            errors.add(OrcidValidationError.EXTERNAL_ID_REQUIRED);
        }
        if (funding.getOrganization() == null) {
            errors.add(OrcidValidationError.FUNDER_REQUIRED);
        } else {
            errors.addAll(this.validate(funding.getOrganization()));
        }
        if (funding.getAmount() != null && StringUtils.isBlank((CharSequence)funding.getAmount().getCurrencyCode())) {
            errors.add(OrcidValidationError.AMOUNT_CURRENCY_REQUIRED);
        }
        return errors;
    }

    private List<OrcidValidationError> validate(Organization organization) {
        ArrayList<OrcidValidationError> errors = new ArrayList<OrcidValidationError>();
        if (StringUtils.isBlank((CharSequence)organization.getName())) {
            errors.add(OrcidValidationError.ORGANIZATION_NAME_REQUIRED);
        }
        errors.addAll(this.validate(organization.getAddress()));
        errors.addAll(this.validate(organization.getDisambiguatedOrganization()));
        return errors;
    }

    private List<OrcidValidationError> validate(DisambiguatedOrganization disambiguatedOrganization) {
        String disambiguationSource;
        ArrayList<OrcidValidationError> errors = new ArrayList<OrcidValidationError>();
        if (disambiguatedOrganization == null) {
            errors.add(OrcidValidationError.DISAMBIGUATED_ORGANIZATION_REQUIRED);
            return errors;
        }
        if (StringUtils.isBlank((CharSequence)disambiguatedOrganization.getDisambiguatedOrganizationIdentifier())) {
            errors.add(OrcidValidationError.DISAMBIGUATED_ORGANIZATION_VALUE_REQUIRED);
        }
        if (StringUtils.isBlank((CharSequence)(disambiguationSource = disambiguatedOrganization.getDisambiguationSource()))) {
            errors.add(OrcidValidationError.DISAMBIGUATION_SOURCE_REQUIRED);
        } else if (this.isInvalidDisambiguationSource(disambiguationSource)) {
            errors.add(OrcidValidationError.DISAMBIGUATION_SOURCE_INVALID);
        }
        return errors;
    }

    private List<OrcidValidationError> validate(OrganizationAddress address) {
        ArrayList<OrcidValidationError> errors = new ArrayList<OrcidValidationError>();
        if (address == null) {
            errors.add(OrcidValidationError.ORGANIZATION_ADDRESS_REQUIRED);
            return errors;
        }
        if (StringUtils.isBlank((CharSequence)address.getCity())) {
            errors.add(OrcidValidationError.ORGANIZATION_CITY_REQUIRED);
        }
        if (address.getCountry() == null) {
            errors.add(OrcidValidationError.ORGANIZATION_COUNTRY_REQUIRED);
        }
        return errors;
    }

    private boolean isYearNotValid(PublicationDate publicationDate) {
        Year year = publicationDate.getYear();
        if (year == null) {
            return true;
        }
        try {
            return Integer.valueOf(year.getValue()) < 1900;
        }
        catch (NumberFormatException ex) {
            return true;
        }
    }

    private boolean isInvalidDisambiguationSource(String disambiguationSource) {
        return !ArrayUtils.contains((Object[])this.getDisambiguedOrganizationSources(), (Object)disambiguationSource);
    }

    private String[] getDisambiguedOrganizationSources() {
        return this.configurationService.getArrayProperty("orcid.validation.organization.identifier-sources");
    }

    private boolean isWorkValidationEnabled() {
        return this.configurationService.getBooleanProperty("orcid.validation.work.enabled", true);
    }

    private boolean isFundingValidationEnabled() {
        return this.configurationService.getBooleanProperty("orcid.validation.funding.enabled", true);
    }
}

