/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.ris.service;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.dspace.importer.external.exception.FileSourceException;
import org.dspace.importer.external.service.components.AbstractPlainMetadataSource;
import org.dspace.importer.external.service.components.dto.PlainMetadataKeyValueItem;
import org.dspace.importer.external.service.components.dto.PlainMetadataSourceDto;

public class RisImportMetadataSourceServiceImpl
extends AbstractPlainMetadataSource {
    @Override
    public String getImportSource() {
        return "RISMetadataSource";
    }

    @Override
    protected List<PlainMetadataSourceDto> readData(InputStream inputStream) throws FileSourceException {
        return this.aggregateData(inputStream);
    }

    private List<PlainMetadataSourceDto> aggregateData(InputStream inputStream) throws FileSourceException {
        ArrayList<PlainMetadataSourceDto> metadata = new ArrayList<PlainMetadataSourceDto>();
        List<PlainMetadataKeyValueItem> notAggregatedItems = this.notAggregatedData(inputStream);
        ArrayList<PlainMetadataKeyValueItem> aggregatedTmpList = null;
        Iterator<PlainMetadataKeyValueItem> itr = notAggregatedItems.iterator();
        while (itr.hasNext()) {
            PlainMetadataSourceDto dto;
            PlainMetadataKeyValueItem item = itr.next();
            if ("TY".equals(item.getKey())) {
                if (aggregatedTmpList != null) {
                    dto = new PlainMetadataSourceDto();
                    dto.setMetadata(new ArrayList<PlainMetadataKeyValueItem>(aggregatedTmpList));
                    metadata.add(dto);
                }
                aggregatedTmpList = new ArrayList<PlainMetadataKeyValueItem>();
                aggregatedTmpList.add(item);
                continue;
            }
            if (aggregatedTmpList == null) continue;
            aggregatedTmpList.add(item);
            if (itr.hasNext()) continue;
            dto = new PlainMetadataSourceDto();
            dto.setMetadata(new ArrayList<PlainMetadataKeyValueItem>(aggregatedTmpList));
            metadata.add(dto);
        }
        return metadata;
    }

    private List<PlainMetadataKeyValueItem> notAggregatedData(InputStream inputStream) throws FileSourceException {
        LinkedList<PlainMetadataKeyValueItem> items = new LinkedList<PlainMetadataKeyValueItem>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.equals("") || line.matches("^\\s*$")) continue;
                Pattern risPattern = Pattern.compile("^([A-Z][A-Z0-9])  - (.*)$");
                Matcher risMatcher = risPattern.matcher(line);
                if (risMatcher.matches()) {
                    PlainMetadataKeyValueItem keyValueItem = new PlainMetadataKeyValueItem();
                    keyValueItem.setValue(risMatcher.group(2));
                    keyValueItem.setKey(risMatcher.group(1));
                    items.add(keyValueItem);
                    continue;
                }
                if (items.isEmpty()) continue;
                items.getLast().setValue(items.getLast().getValue().concat(line));
            }
        }
        catch (Exception e) {
            throw new FileSourceException("Cannot parse RIS file", e);
        }
        return items;
    }

    @Override
    @Resource(name="risMetadataFieldMap")
    public void setMetadataFieldMap(Map metadataFieldMap) {
        super.setMetadataFieldMap(metadataFieldMap);
    }
}

