/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.contributor.JsonPathMetadataProcessor;

public class MatrixElementProcessor
implements JsonPathMetadataProcessor {
    private static final Logger log = LogManager.getLogger();
    private String pathToMatrix;

    @Override
    public Collection<String> processMetadata(String json) {
        JsonNode rootNode = this.convertStringJsonToJsonNode(json);
        Iterator array = rootNode.at(this.pathToMatrix).elements();
        ArrayList<String> values = new ArrayList<String>();
        while (array.hasNext()) {
            JsonNode element = (JsonNode)array.next();
            if (element.isArray()) {
                Iterator nodes = element.iterator();
                while (nodes.hasNext()) {
                    String nodeValue = ((JsonNode)nodes.next()).textValue();
                    if (!StringUtils.isNotBlank((CharSequence)nodeValue)) continue;
                    values.add(nodeValue);
                }
                continue;
            }
            String nodeValue = element.textValue();
            if (!StringUtils.isNotBlank((CharSequence)nodeValue)) continue;
            values.add(nodeValue);
        }
        return values;
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode body = null;
        try {
            body = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
        }
        return body;
    }

    public void setPathToMatrix(String pathToMatrix) {
        this.pathToMatrix = pathToMatrix;
    }
}

