/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.iiif.canvasdimension;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.iiif.IIIFApiQueryService;
import org.dspace.iiif.canvasdimension.ImageDimensionReader;
import org.dspace.iiif.canvasdimension.service.IIIFCanvasDimensionService;
import org.dspace.iiif.util.IIIFSharedUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class IIIFCanvasDimensionServiceImpl
implements IIIFCanvasDimensionService {
    @Autowired
    ItemService itemService;
    @Autowired
    CommunityService communityService;
    @Autowired
    BitstreamService bitstreamService;
    @Autowired
    DSpaceObjectService<Bitstream> dSpaceObjectService;
    @Autowired
    IIIFApiQueryService iiifApiQuery;
    private boolean forceProcessing = false;
    private boolean isQuiet = false;
    private List<String> skipList = null;
    private int max2Process = Integer.MAX_VALUE;
    private int processed = 0;
    private static final String IIIF_WIDTH_METADATA = "iiif.image.width";

    @Override
    public void setForceProcessing(boolean force) {
        this.forceProcessing = force;
    }

    @Override
    public void setIsQuiet(boolean quiet) {
        this.isQuiet = quiet;
    }

    @Override
    public void setMax2Process(int max2Process) {
        this.max2Process = max2Process;
    }

    @Override
    public void setSkipList(List<String> skipList) {
        this.skipList = skipList;
    }

    @Override
    public int processCommunity(Context context, Community community) throws Exception {
        if (!this.inSkipList(community.getHandle())) {
            List<Community> subcommunities = community.getSubcommunities();
            for (Community subcommunity : subcommunities) {
                this.processCommunity(context, subcommunity);
            }
            List<Collection> collections = community.getCollections();
            for (Collection collection : collections) {
                this.processCollection(context, collection);
            }
        }
        return this.processed;
    }

    @Override
    public int processCollection(Context context, Collection collection) throws Exception {
        if (!this.inSkipList(collection.getHandle())) {
            Iterator<Item> itemIterator = this.itemService.findAllByCollection(context, collection);
            while (itemIterator.hasNext() && this.processed < this.max2Process) {
                this.processItem(context, itemIterator.next());
            }
        }
        return this.processed;
    }

    @Override
    public void processItem(Context context, Item item) throws Exception {
        boolean isIIIFItem;
        if (!this.inSkipList(item.getHandle()) && (isIIIFItem = IIIFSharedUtils.isIIIFItem(item))) {
            if (this.processItemBundles(context, item)) {
                ++this.processed;
            }
            context.uncacheEntity(item);
        }
    }

    private boolean processItemBundles(Context context, Item item) throws Exception {
        List<Bundle> bundles = IIIFSharedUtils.getIIIFBundles(item);
        boolean done = false;
        for (Bundle bundle : bundles) {
            List<Bitstream> bitstreams = bundle.getBitstreams();
            for (Bitstream bit : bitstreams) {
                done |= this.processBitstream(context, bit);
                context.uncacheEntity(bit);
            }
        }
        if (done && !this.isQuiet) {
            System.out.println("Updated canvas metadata for item: " + item.getID());
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processBitstream(Context context, Bitstream bitstream) throws SQLException, AuthorizeException, IOException {
        Optional<MetadataValue> op;
        boolean processed = false;
        boolean isImage = bitstream.getFormat(context).getMIMEType().contains("image/");
        if (isImage && ((op = bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(IIIF_WIDTH_METADATA)).findFirst()).isEmpty() || this.forceProcessing)) {
            int[] dims;
            if (this.forceProcessing && !this.isQuiet) {
                System.out.println("Force processing for bitstream: " + bitstream.getID());
            }
            try (InputStream stream = null;){
                stream = this.bitstreamService.retrieve(context, bitstream);
                try {
                    dims = ImageDimensionReader.getImageDimensions(stream);
                    if (dims == null) {
                        dims = this.iiifApiQuery.getImageDimensions(bitstream);
                    }
                }
                catch (IOException e) {
                    dims = this.iiifApiQuery.getImageDimensions(bitstream);
                }
            }
            if (dims != null) {
                processed = this.setBitstreamMetadata(context, bitstream, dims);
                this.bitstreamService.update(context, bitstream);
            }
        }
        return processed;
    }

    private boolean setBitstreamMetadata(Context context, Bitstream bitstream, int[] dims) throws SQLException {
        this.dSpaceObjectService.clearMetadata(context, bitstream, "iiif", "image", "width", "*");
        this.dSpaceObjectService.setMetadataSingleValue(context, bitstream, "iiif", "image", "width", null, String.valueOf(dims[0]));
        this.dSpaceObjectService.clearMetadata(context, bitstream, "iiif", "image", "height", "*");
        this.dSpaceObjectService.setMetadataSingleValue(context, bitstream, "iiif", "image", "height", null, String.valueOf(dims[1]));
        if (!this.isQuiet) {
            System.out.println("Added IIIF canvas metadata to bitstream: " + bitstream.getID());
        }
        return true;
    }

    private boolean inSkipList(String identifier) {
        if (this.skipList != null && this.skipList.contains(identifier)) {
            if (!this.isQuiet) {
                System.out.println("SKIP-LIST: skipped bitstreams within identifier " + identifier);
            }
            return true;
        }
        return false;
    }
}

