/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.harvest.HarvestScheduler;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.service.HarvestSchedulingService;
import org.dspace.harvest.service.HarvestedCollectionService;
import org.springframework.beans.factory.annotation.Autowired;

public class HarvestSchedulingServiceImpl
implements HarvestSchedulingService {
    protected HarvestScheduler harvester;
    protected Thread mainHarvestThread;
    protected HarvestScheduler harvestScheduler;
    @Autowired(required=true)
    protected HarvestedCollectionService harvestedCollectionService;

    protected HarvestSchedulingServiceImpl() {
    }

    @Override
    public synchronized void startNewScheduler() throws SQLException, AuthorizeException {
        Context c = new Context();
        this.harvestedCollectionService.exists(c);
        c.complete();
        if (this.mainHarvestThread != null && this.harvester != null) {
            this.stopScheduler();
        }
        this.harvester = new HarvestScheduler();
        HarvestScheduler.setInterrupt(0);
        this.mainHarvestThread = new Thread(this.harvester);
        this.mainHarvestThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopScheduler() throws SQLException, AuthorizeException {
        Object object = HarvestScheduler.lock;
        synchronized (object) {
            HarvestScheduler.setInterrupt(2);
            HarvestScheduler.lock.notify();
        }
        this.mainHarvestThread = null;
        this.harvester = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseScheduler() throws SQLException, AuthorizeException {
        Object object = HarvestScheduler.lock;
        synchronized (object) {
            HarvestScheduler.setInterrupt(1);
            HarvestScheduler.lock.notify();
        }
    }

    @Override
    public void resumeScheduler() throws SQLException, AuthorizeException {
        HarvestScheduler.setInterrupt(3);
    }

    @Override
    public void resetScheduler() throws SQLException, AuthorizeException, IOException {
        Context context = new Context();
        List<HarvestedCollection> harvestedCollections = this.harvestedCollectionService.findAll(context);
        for (HarvestedCollection hc : harvestedCollections) {
            hc.setHarvestStartTime(null);
            hc.setHarvestStatus(0);
            this.harvestedCollectionService.update(context, hc);
        }
    }
}

