/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.sherpa.SHERPAService;
import org.dspace.app.sherpa.v2.SHERPAPublisher;
import org.dspace.app.sherpa.v2.SHERPAPublisherResponse;
import org.dspace.app.sherpa.v2.SHERPAUtils;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.AbstractExternalDataProvider;

public class SHERPAv2PublisherDataProvider
extends AbstractExternalDataProvider {
    private String sourceIdentifier;
    private SHERPAService sherpaService;

    @Override
    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public void init() throws IOException {
    }

    @Override
    public Optional<ExternalDataObject> getExternalDataObject(String id) {
        SHERPAPublisherResponse sherpaResponse = this.sherpaService.performPublisherRequest("publisher", "id", "equals", id = SHERPAUtils.sanitiseQuery(id), 0, 1);
        if (CollectionUtils.isNotEmpty(sherpaResponse.getPublishers())) {
            SHERPAPublisher sherpaPublisher = sherpaResponse.getPublishers().get(0);
            ExternalDataObject externalDataObject = this.constructExternalDataObjectFromSherpaPublisher(sherpaPublisher);
            return Optional.of(externalDataObject);
        }
        return Optional.empty();
    }

    @Override
    public List<ExternalDataObject> searchExternalDataObjects(String query, int start, int limit) {
        SHERPAPublisherResponse sherpaResponse = this.sherpaService.performPublisherRequest("publisher", "name", "contains word", query, start, limit);
        if (CollectionUtils.isNotEmpty(sherpaResponse.getPublishers())) {
            List<ExternalDataObject> list = sherpaResponse.getPublishers().stream().map(sherpaPublisher -> this.constructExternalDataObjectFromSherpaPublisher((SHERPAPublisher)sherpaPublisher)).collect(Collectors.toList());
            return list;
        }
        return Collections.emptyList();
    }

    private ExternalDataObject constructExternalDataObjectFromSherpaPublisher(SHERPAPublisher sherpaPublisher) {
        ExternalDataObject externalDataObject = new ExternalDataObject();
        externalDataObject.setSource(this.sourceIdentifier);
        if (StringUtils.isNotBlank((CharSequence)sherpaPublisher.getName())) {
            externalDataObject.addMetadata(new MetadataValueDTO("dc", "title", null, null, sherpaPublisher.getName()));
            externalDataObject.setDisplayValue(sherpaPublisher.getName());
            externalDataObject.setValue(sherpaPublisher.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)sherpaPublisher.getIdentifier())) {
            externalDataObject.setId(sherpaPublisher.getIdentifier());
            externalDataObject.addMetadata(new MetadataValueDTO("dc", "identifier", "sherpaPublisher", null, sherpaPublisher.getIdentifier()));
        }
        if (StringUtils.isNotBlank((CharSequence)sherpaPublisher.getUri())) {
            externalDataObject.addMetadata(new MetadataValueDTO("dc", "identifier", "other", null, sherpaPublisher.getUri()));
        }
        return externalDataObject;
    }

    @Override
    public boolean supports(String source) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.sourceIdentifier, (CharSequence)source);
    }

    @Override
    public int getNumberOfResults(String query) {
        SHERPAPublisherResponse sherpaResponse = this.sherpaService.performPublisherRequest("publication", "title", "contains word", query, 0, 0);
        if (CollectionUtils.isNotEmpty(sherpaResponse.getPublishers())) {
            return sherpaResponse.getPublishers().size();
        }
        return 0;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public void setSherpaService(SHERPAService sherpaService) {
        this.sherpaService = sherpaService;
    }
}

