/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson.dao.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Subscription;
import org.dspace.eperson.SubscriptionParameter_;
import org.dspace.eperson.Subscription_;
import org.dspace.eperson.dao.SubscriptionDAO;

public class SubscriptionDAOImpl
extends AbstractHibernateDAO<Subscription>
implements SubscriptionDAO {
    protected SubscriptionDAOImpl() {
    }

    @Override
    public List<Subscription> findByEPerson(Context context, EPerson eperson, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Subscription> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Subscription.class);
        Root subscriptionRoot = criteriaQuery.from(Subscription.class);
        criteriaQuery.select((Selection)subscriptionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)subscriptionRoot.get(Subscription_.ePerson), (Object)eperson));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)subscriptionRoot.get(Subscription_.dSpaceObject)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, Subscription.class, limit, offset);
    }

    @Override
    public List<Subscription> findByEPersonAndDso(Context context, EPerson eperson, DSpaceObject dSpaceObject, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Subscription> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Subscription.class);
        Root subscriptionRoot = criteriaQuery.from(Subscription.class);
        criteriaQuery.select((Selection)subscriptionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)subscriptionRoot.get(Subscription_.ePerson), (Object)eperson), (Expression)criteriaBuilder.equal((Expression)subscriptionRoot.get(Subscription_.dSpaceObject), (Object)dSpaceObject)));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)subscriptionRoot.get(Subscription_.dSpaceObject)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, Subscription.class, limit, offset);
    }

    @Override
    public void deleteByDspaceObject(Context context, DSpaceObject dSpaceObject) throws SQLException {
        String hqlQuery = "delete from Subscription where dSpaceObject=:dSpaceObject";
        Query query = this.createQuery(context, hqlQuery);
        query.setParameter("dSpaceObject", (Object)dSpaceObject);
        query.executeUpdate();
    }

    @Override
    public void deleteByEPerson(Context context, EPerson eperson) throws SQLException {
        String hqlQuery = "delete from Subscription where ePerson=:ePerson";
        Query query = this.createQuery(context, hqlQuery);
        query.setParameter("ePerson", (Object)eperson);
        query.executeUpdate();
    }

    @Override
    public void deleteByDSOAndEPerson(Context context, DSpaceObject dSpaceObject, EPerson eperson) throws SQLException {
        String hqlQuery = "delete from Subscription where dSpaceObject=:dSpaceObject AND ePerson=:ePerson";
        Query query = this.createQuery(context, hqlQuery);
        query.setParameter("dSpaceObject", (Object)dSpaceObject);
        query.setParameter("ePerson", (Object)eperson);
        query.executeUpdate();
    }

    @Override
    public List<Subscription> findAllOrderedByIDAndResourceType(Context context, String resourceType, Integer limit, Integer offset) throws SQLException {
        String hqlQuery = "select s from Subscription s join %s dso ON dso.id = s.dSpaceObject ORDER BY subscription_id";
        if (resourceType != null) {
            hqlQuery = String.format(hqlQuery, resourceType);
        }
        Query query = this.createQuery(context, hqlQuery);
        if (limit != -1) {
            query.setMaxResults(limit.intValue());
        }
        if (offset != -1) {
            query.setFirstResult(offset.intValue());
        }
        query.setHint("org.hibernate.cacheable", (Object)false);
        return query.getResultList();
    }

    @Override
    public List<Subscription> findAllOrderedByDSO(Context context, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Subscription> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Subscription.class);
        Root subscriptionRoot = criteriaQuery.from(Subscription.class);
        criteriaQuery.select((Selection)subscriptionRoot);
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)subscriptionRoot.get(Subscription_.dSpaceObject)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, Subscription.class, limit, offset);
    }

    @Override
    public List<Subscription> findAllSubscriptionsBySubscriptionTypeAndFrequency(Context context, String subscriptionType, String frequencyValue) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Subscription> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Subscription.class);
        Root subscriptionRoot = criteriaQuery.from(Subscription.class);
        criteriaQuery.select((Selection)subscriptionRoot);
        Join childJoin = subscriptionRoot.join("subscriptionParameterList");
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)subscriptionRoot.get("subscriptionType"), (Object)subscriptionType), criteriaBuilder.equal((Expression)childJoin.get(SubscriptionParameter_.name), (Object)"frequency"), criteriaBuilder.equal((Expression)childJoin.get(SubscriptionParameter_.value), (Object)frequencyValue)}));
        ArrayList<Order> orderList = new ArrayList<Order>(1);
        orderList.add(criteriaBuilder.asc((Expression)subscriptionRoot.get(Subscription_.ePerson)));
        orderList.add(criteriaBuilder.asc((Expression)subscriptionRoot.get(Subscription_.id)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, Subscription.class, 10000, -1);
    }

    @Override
    public Long countAll(Context context) throws SQLException {
        CriteriaBuilder qb = this.getCriteriaBuilder(context);
        CriteriaQuery cq = qb.createQuery(Long.class);
        cq.select((Selection)qb.count((Expression)cq.from(Subscription.class)));
        org.hibernate.query.Query query = this.getHibernateSession(context).createQuery(cq);
        return (Long)query.getSingleResult();
    }

    @Override
    public Long countAllByEPerson(Context context, EPerson ePerson) throws SQLException {
        CriteriaBuilder qb = this.getCriteriaBuilder(context);
        CriteriaQuery cq = qb.createQuery(Long.class);
        Root subscriptionRoot = cq.from(Subscription.class);
        cq.select((Selection)qb.count((Expression)subscriptionRoot));
        cq.where((Expression)qb.equal((Expression)subscriptionRoot.get(Subscription_.ePerson), (Object)ePerson));
        org.hibernate.query.Query query = this.getHibernateSession(context).createQuery(cq);
        return (Long)query.getSingleResult();
    }

    @Override
    public Long countAllByEPersonAndDso(Context context, EPerson ePerson, DSpaceObject dSpaceObject) throws SQLException {
        CriteriaBuilder qb = this.getCriteriaBuilder(context);
        CriteriaQuery cq = qb.createQuery(Long.class);
        Root subscriptionRoot = cq.from(Subscription.class);
        cq.select((Selection)qb.count((Expression)subscriptionRoot));
        cq.where((Expression)qb.and((Expression)qb.equal((Expression)subscriptionRoot.get(Subscription_.ePerson), (Object)ePerson), (Expression)qb.equal((Expression)subscriptionRoot.get(Subscription_.dSpaceObject), (Object)dSpaceObject)));
        org.hibernate.query.Query query = this.getHibernateSession(context).createQuery(cq);
        return (Long)query.getSingleResult();
    }
}

