/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.indexobject;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.core.Context;
import org.dspace.discovery.indexobject.IndexFactoryImpl;
import org.dspace.discovery.indexobject.IndexablePoolTask;
import org.dspace.discovery.indexobject.factory.PoolTaskIndexFactory;
import org.dspace.discovery.indexobject.factory.WorkflowItemIndexFactory;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.springframework.beans.factory.annotation.Autowired;

public class PoolTaskIndexFactoryImpl
extends IndexFactoryImpl<IndexablePoolTask, PoolTask>
implements PoolTaskIndexFactory {
    @Autowired
    protected PoolTaskService poolTaskService;
    @Autowired
    WorkflowItemIndexFactory indexableWorkflowItemService;

    @Override
    public Iterator<IndexablePoolTask> findAll(Context context) throws SQLException {
        final Iterator<PoolTask> pooledTasks = this.poolTaskService.findAll(context).iterator();
        return new Iterator<IndexablePoolTask>(){

            @Override
            public boolean hasNext() {
                return pooledTasks.hasNext();
            }

            @Override
            public IndexablePoolTask next() {
                return new IndexablePoolTask((PoolTask)pooledTasks.next());
            }
        };
    }

    @Override
    public String getType() {
        return IndexablePoolTask.TYPE;
    }

    @Override
    public SolrInputDocument buildDocument(Context context, IndexablePoolTask indexableObject) throws SQLException, IOException {
        String acvalue;
        SolrInputDocument doc = super.buildDocument(context, indexableObject);
        PoolTask poolTask = indexableObject.getIndexedObject();
        this.indexableWorkflowItemService.storeInprogressItemFields(context, doc, poolTask.getWorkflowItem());
        this.addFacetIndex(doc, "action", poolTask.getActionID(), poolTask.getActionID());
        this.addFacetIndex(doc, "step", poolTask.getStepID(), poolTask.getStepID());
        if (poolTask.getEperson() != null) {
            doc.addField("taskfor", (Object)("e" + poolTask.getEperson().getID().toString()));
        }
        if (poolTask.getGroup() != null) {
            doc.addField("taskfor", (Object)("g" + poolTask.getGroup().getID().toString()));
        }
        if (StringUtils.isBlank((CharSequence)(acvalue = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("discovery.facet.namedtype.workflow.pooled")))) {
            acvalue = indexableObject.getTypeText();
        }
        this.addNamedResourceTypeIndex(doc, acvalue);
        return doc;
    }

    @Override
    public boolean supports(Object object) {
        return object instanceof PoolTask;
    }

    @Override
    public List getIndexableObjects(Context context, PoolTask object) {
        return Arrays.asList(new IndexablePoolTask(object));
    }

    @Override
    public Optional<IndexablePoolTask> findIndexableObject(Context context, String id) throws SQLException {
        PoolTask poolTask = (PoolTask)this.poolTaskService.find(context, Integer.parseInt(id));
        return poolTask == null ? Optional.empty() : Optional.of(new IndexablePoolTask(poolTask));
    }
}

