/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.indexobject;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.MetadataField;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.core.Context;
import org.dspace.discovery.indexobject.IndexFactoryImpl;
import org.dspace.discovery.indexobject.IndexableMetadataField;
import org.dspace.discovery.indexobject.factory.MetadataFieldIndexFactory;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;

public class MetadataFieldIndexFactoryImpl
extends IndexFactoryImpl<IndexableMetadataField, MetadataField>
implements MetadataFieldIndexFactory {
    public static final String SCHEMA_FIELD_NAME = "schema";
    public static final String ELEMENT_FIELD_NAME = "element";
    public static final String QUALIFIER_FIELD_NAME = "qualifier";
    public static final String FIELD_NAME_VARIATIONS = "fieldName";
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    @Autowired
    private MetadataFieldService metadataFieldService;

    @Override
    public SolrInputDocument buildDocument(Context context, IndexableMetadataField indexableObject) throws SQLException, IOException {
        SolrInputDocument doc = super.buildDocument(context, indexableObject);
        MetadataField metadataField = indexableObject.getIndexedObject();
        this.addFacetIndex(doc, SCHEMA_FIELD_NAME, metadataField.getMetadataSchema().getName(), metadataField.getMetadataSchema().getName());
        this.addFacetIndex(doc, ELEMENT_FIELD_NAME, metadataField.getElement(), metadataField.getElement());
        String fieldName = metadataField.toString().replace('_', '.');
        this.addFacetIndex(doc, FIELD_NAME_VARIATIONS, fieldName, fieldName);
        if (StringUtils.isNotBlank((CharSequence)metadataField.getQualifier())) {
            this.addFacetIndex(doc, QUALIFIER_FIELD_NAME, metadataField.getQualifier(), metadataField.getQualifier());
            this.addFacetIndex(doc, FIELD_NAME_VARIATIONS, fieldName, metadataField.getElement() + "." + metadataField.getQualifier());
            this.addFacetIndex(doc, FIELD_NAME_VARIATIONS, metadataField.getQualifier(), metadataField.getQualifier());
        } else {
            this.addFacetIndex(doc, FIELD_NAME_VARIATIONS, metadataField.getElement(), metadataField.getElement());
        }
        this.addNamedResourceTypeIndex(doc, indexableObject.getTypeText());
        Group anonymousGroup = this.groupService.findByName(context, "Anonymous");
        doc.addField("read", (Object)("g" + anonymousGroup.getID()));
        doc.addField("fieldName_sort", (Object)fieldName);
        return doc;
    }

    @Override
    public Iterator<IndexableMetadataField> findAll(Context context) throws SQLException {
        final Iterator<MetadataField> metadataFields = this.metadataFieldService.findAll(context).iterator();
        return new Iterator<IndexableMetadataField>(){

            @Override
            public boolean hasNext() {
                return metadataFields.hasNext();
            }

            @Override
            public IndexableMetadataField next() {
                return new IndexableMetadataField((MetadataField)metadataFields.next());
            }
        };
    }

    @Override
    public String getType() {
        return IndexableMetadataField.TYPE;
    }

    @Override
    public Optional<IndexableMetadataField> findIndexableObject(Context context, String id) throws SQLException {
        MetadataField metadataField = this.metadataFieldService.find(context, Integer.parseInt(id));
        return metadataField == null ? Optional.empty() : Optional.of(new IndexableMetadataField(metadataField));
    }

    @Override
    public boolean supports(Object object) {
        return object instanceof MetadataField;
    }

    @Override
    public List getIndexableObjects(Context context, MetadataField object) {
        return Arrays.asList(new IndexableMetadataField(object));
    }
}

