/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.IndexingUtils;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.indexobject.IndexableItem;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrServiceIndexItemEditorsPlugin
implements SolrServiceIndexPlugin {
    private static final Logger log = LogManager.getLogger(SolrServiceIndexItemEditorsPlugin.class);
    @Autowired(required=true)
    protected AuthorizeService authorizeService;

    @Override
    public void additionalIndex(Context context, IndexableObject idxObj, SolrInputDocument document) {
        Item item;
        if (idxObj instanceof IndexableItem && (item = (Item)((IndexableItem)idxObj).getIndexedObject()) != null) {
            try {
                for (Collection collection : item.getCollections()) {
                    for (UUID unprefixedId : IndexingUtils.findTransitiveAdminGroupIds(context, collection)) {
                        document.addField("edit", (Object)("g" + unprefixedId));
                    }
                }
                List<String> prefixedIds = IndexingUtils.findDirectlyAuthorizedGroupAndEPersonPrefixedIds(this.authorizeService, context, item, new int[]{1, 11});
                for (String prefixedId : prefixedIds) {
                    document.addField("edit", (Object)prefixedId);
                }
            }
            catch (SQLException e) {
                log.error(LogHelper.getHeader(context, "Error while indexing resource policies", "Item: (id " + item.getID() + " name " + item.getName() + ")"));
            }
        }
    }
}

