/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;

public class DiscoverResult {
    private long totalSearchResults;
    private int start;
    private List<IndexableObject> indexableObjects = new ArrayList<IndexableObject>();
    private Map<String, List<FacetResult>> facetResults = new LinkedHashMap<String, List<FacetResult>>();
    private long totalEntries;
    private Map<String, List<SearchDocument>> searchDocuments = new LinkedHashMap<String, List<SearchDocument>>();
    private int maxResults = -1;
    private int searchTime;
    private Map<String, IndexableObjectHighlightResult> highlightedResults = new HashMap<String, IndexableObjectHighlightResult>();
    private String spellCheckQuery;

    public void addIndexableObject(IndexableObject idxObj) {
        this.indexableObjects.add(idxObj);
    }

    public List<IndexableObject> getIndexableObjects() {
        return this.indexableObjects;
    }

    public long getTotalSearchResults() {
        return this.totalSearchResults;
    }

    public void setTotalSearchResults(long totalSearchResults) {
        this.totalSearchResults = totalSearchResults;
    }

    public long getTotalEntries() {
        return this.totalEntries;
    }

    public void setTotalEntries(long totalEntries) {
        this.totalEntries = totalEntries;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getSearchTime() {
        return this.searchTime;
    }

    public void setSearchTime(int searchTime) {
        this.searchTime = searchTime;
    }

    public void addFacetResult(String facetField, FacetResult ... facetResults) {
        List<FacetResult> facetValues = this.facetResults.get(facetField);
        if (facetValues == null) {
            facetValues = new ArrayList<FacetResult>();
        }
        facetValues.addAll(Arrays.asList(facetResults));
        this.facetResults.put(facetField, facetValues);
    }

    public Map<String, List<FacetResult>> getFacetResults() {
        return this.facetResults;
    }

    public List<FacetResult> getFacetResult(String facet) {
        return ListUtils.emptyIfNull(this.facetResults.get(facet));
    }

    public List<FacetResult> getFacetResult(DiscoverySearchFilterFacet field) {
        List<FacetResult> facetValues = this.getFacetResult(field.getIndexFieldName());
        if (facetValues.size() == 0 && field.getType().equals("date")) {
            facetValues = this.getFacetResult(field.getIndexFieldName() + ".year");
        }
        if (facetValues.isEmpty()) {
            facetValues = this.getFacetResult(field.getIndexFieldName() + "_prefix");
        }
        return ListUtils.emptyIfNull(facetValues);
    }

    public IndexableObjectHighlightResult getHighlightedResults(IndexableObject dso) {
        return this.highlightedResults.get(dso.getUniqueIndexID());
    }

    public void addHighlightedResult(IndexableObject dso, IndexableObjectHighlightResult highlightedResult) {
        this.highlightedResults.put(dso.getUniqueIndexID(), highlightedResult);
    }

    public String getSpellCheckQuery() {
        return this.spellCheckQuery;
    }

    public void setSpellCheckQuery(String spellCheckQuery) {
        this.spellCheckQuery = spellCheckQuery;
    }

    public void addSearchDocument(IndexableObject dso, SearchDocument searchDocument) {
        String dsoString = SearchDocument.getIndexableObjectStringRepresentation(dso);
        List<SearchDocument> docs = this.searchDocuments.get(dsoString);
        if (docs == null) {
            docs = new ArrayList<SearchDocument>();
        }
        docs.add(searchDocument);
        this.searchDocuments.put(dsoString, docs);
    }

    public List<SearchDocument> getSearchDocument(IndexableObject idxObj) {
        String dsoString = SearchDocument.getIndexableObjectStringRepresentation(idxObj);
        List<SearchDocument> result = this.searchDocuments.get(dsoString);
        if (result == null) {
            return new ArrayList<SearchDocument>();
        }
        return result;
    }

    public static final class IndexableObjectHighlightResult {
        private IndexableObject indexableObject;
        private Map<String, List<String>> highlightResults;

        public IndexableObjectHighlightResult(IndexableObject idxObj, Map<String, List<String>> highlightResults) {
            this.indexableObject = idxObj;
            this.highlightResults = highlightResults;
        }

        public IndexableObject getIndexableObject() {
            return this.indexableObject;
        }

        public List<String> getHighlightResults(String metadataKey) {
            return this.highlightResults.get(metadataKey);
        }

        public Map<String, List<String>> getHighlightResults() {
            return this.highlightResults;
        }
    }

    public static final class SearchDocument {
        private Map<String, List<String>> searchFields = new LinkedHashMap<String, List<String>>();

        public void addSearchField(String field, String ... values) {
            List<String> searchFieldValues = this.searchFields.get(field);
            if (searchFieldValues == null) {
                searchFieldValues = new ArrayList<String>();
            }
            searchFieldValues.addAll(Arrays.asList(values));
            this.searchFields.put(field, searchFieldValues);
        }

        public Map<String, List<String>> getSearchFields() {
            return this.searchFields;
        }

        public List<String> getSearchFieldValues(String field) {
            if (this.searchFields.get(field) == null) {
                return new ArrayList<String>();
            }
            return this.searchFields.get(field);
        }

        public static String getIndexableObjectStringRepresentation(IndexableObject idxObj) {
            return idxObj.getType() + ":" + idxObj.getID();
        }
    }

    public static final class FacetResult {
        private String asFilterQuery;
        private String displayedValue;
        private String authorityKey;
        private String sortValue;
        private long count;
        private String fieldType;

        public FacetResult(String asFilterQuery, String displayedValue, String authorityKey, String sortValue, long count, String fieldType) {
            this.asFilterQuery = asFilterQuery;
            this.displayedValue = displayedValue;
            this.authorityKey = authorityKey;
            this.sortValue = sortValue;
            this.count = count;
            this.fieldType = fieldType;
        }

        public String getAsFilterQuery() {
            if (this.asFilterQuery == null) {
                return "[* TO *]";
            }
            return this.asFilterQuery;
        }

        public String getDisplayedValue() {
            return this.displayedValue;
        }

        public String getSortValue() {
            return this.sortValue;
        }

        public long getCount() {
            return this.count;
        }

        public String getAuthorityKey() {
            return this.authorityKey;
        }

        public String getFilterType() {
            return this.authorityKey != null ? "authority" : (this.asFilterQuery != null ? "equals" : "notequals");
        }

        public String getFieldType() {
            return this.fieldType;
        }
    }
}

