/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.cli.Options;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.curate.Curation;
import org.dspace.curate.CurationClientOptions;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.configuration.ScriptConfiguration;

public class CurationScriptConfiguration<T extends Curation>
extends ScriptConfiguration<T> {
    private Class<T> dspaceRunnableClass;

    @Override
    public Class<T> getDspaceRunnableClass() {
        return this.dspaceRunnableClass;
    }

    @Override
    public void setDspaceRunnableClass(Class<T> dspaceRunnableClass) {
        this.dspaceRunnableClass = dspaceRunnableClass;
    }

    @Override
    public boolean isAllowedToExecute(Context context, List<DSpaceCommandLineParameter> commandLineParameters) {
        try {
            if (commandLineParameters == null) {
                return this.authorizeService.isAdmin(context) || this.authorizeService.isComColAdmin(context) || this.authorizeService.isItemAdmin(context);
            }
            if (commandLineParameters.stream().map(DSpaceCommandLineParameter::getName).noneMatch("-i"::equals)) {
                return this.authorizeService.isAdmin(context);
            }
            String dspaceObjectID = commandLineParameters.stream().filter(parameter -> "-i".equals(parameter.getName())).map(DSpaceCommandLineParameter::getValue).findFirst().get();
            HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
            DSpaceObject dso = handleService.resolveToObject(context, dspaceObjectID);
            return this.authorizeService.isAdmin(context, dso);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            this.options = CurationClientOptions.constructOptions();
        }
        return this.options;
    }
}

