/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public enum CurationClientOptions {
    TASK,
    QUEUE,
    HELP;

    private static List<String> taskOptions;

    protected static CurationClientOptions getClientOption(CommandLine commandLine) {
        if (commandLine.hasOption("h")) {
            return HELP;
        }
        if (commandLine.hasOption("t") || commandLine.hasOption("T")) {
            return TASK;
        }
        if (commandLine.hasOption("q")) {
            return QUEUE;
        }
        return null;
    }

    protected static Options constructOptions() {
        Options options = new Options();
        options.addOption("t", "task", true, "curation task name; options: " + CurationClientOptions.getTaskOptions());
        options.addOption("T", "taskfile", true, "file containing curation task names");
        options.addOption("i", "id", true, "Id (handle) of object to perform task on, or 'all' to perform on whole repository");
        options.addOption("p", "parameter", true, "a task parameter 'NAME=VALUE'");
        options.addOption("q", "queue", true, "name of task queue to process");
        options.addOption("r", "reporter", true, "relative or absolute path to the desired report file. Use '-' to report to console. If absent, no reporting");
        options.addOption("s", "scope", true, "transaction scope to impose: use 'object', 'curation', or 'open'. If absent, 'open' applies");
        options.addOption("v", "verbose", false, "report activity to stdout");
        options.addOption("h", "help", false, "help");
        return options;
    }

    public static List<String> getTaskOptions() {
        if (taskOptions == null) {
            ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
            String[] taskConfigs = configurationService.getArrayProperty("plugin.named.org.dspace.curate.CurationTask");
            taskOptions = new ArrayList<String>();
            for (String taskConfig : taskConfigs) {
                taskOptions.add(StringUtils.substringAfterLast((String)taskConfig, (String)"=").trim());
            }
        }
        return taskOptions;
    }
}

